#!/usr/bin/perl


=head1 NAME

passport_subscribe.pl

=head1 DESCRIPTION

Скрипт подписывает указанные логины на sid Директа в Паспорте

=head1 RUNNING

    Запускать с параметрами:
        --login - логин, который нужно подписать на sid Директа, можно указывать несколько раз

    LOG_TEE=1 ./passport_subscribe.pl --login zx128k --login elama-16183766

=cut

use Direct::Modern;

use Yandex::Passport;

use my_inc '../..';

use PrimitivesIds;
use ScriptHelper;
use Settings;

my @logins;
extract_script_params(
    'login=s@' => \@logins,
);

$log->out('START');

foreach my $login (@logins) {
    my $uid = get_uid(login => $login);
    if ($uid) {
        my $res = Yandex::Passport::subscribe_service($uid);
        $log->out("subscribe $login ($uid) " . ($res ? 'error' : 'ok'));
    } else {
        $log->out("user with login $login not found");
    }
}

$log->out('FINISH');
