#!/usr/bin/perl

use my_inc "../..";


=head1 NAME
    
    phrase_geo_id.pl

=head1 DESCRIPTION

    Переписываем содержимое колонки phrase_geo_id в ppcdict.suggest_phrases
    Работаем в несколько потоков для скорости

    Необходим для первоначальной инциализации.
    Возможно, будет полезен при последующей смене алгоритма для быстрого обновления всех данных.

=cut


use strict;
use warnings;

use Settings;
use Yandex::DBTools;
use Yandex::HashUtils;
use Yandex::Log;
use PhraseText;
use Parallel::ForkManager;
use utf8;
use open ':std' => ':utf8';



my $log = Yandex::Log->new(log_file_name => 'phrase_geo_id.log', date_suf => '%Y%m%d');
$log->out('start');
my $WORKERS = 10;
my $pm = Parallel::ForkManager->new($WORKERS);

for my $num (0 .. $WORKERS - 1) {
    my $pid = $pm->start and next;
    process_part($num, $WORKERS);
    $pm->finish;
}
$pm->wait_all_children;
$log->out('finish');


sub process_part
{
    my ($num, $total) = @_;

    $log->out([$num, $total, $$, 'start']);
    my $phrases = get_all_sql(PPCDICT, "select phrase_hash, phrase from suggest_phrases where phrase_hash % $total = $num");
    $log->out([$num, $total, $$, scalar(@$phrases)]);
    my $cnt = 0;
    for my $phrase (@$phrases) {
        if (my $phrase_geo_id = PhraseText::get_phrase_geo_id($phrase->{phrase})) {
            do_update_table(PPCDICT, 'suggest_phrases', {phrase_geo_id => $phrase_geo_id}, where => hash_cut($phrase, qw/phrase_hash/));
            $cnt += 1;
        }
    } 
    $log->out([$num, $total, $$, "$cnt processed"]);
    $log->out([$num, $total, $$, 'finish']);
}
