#!/usr/bin/perl

use my_inc "../..";

=head1 DESCRIPTION

Скрипт для разового переноса данных диалогов из camp_dialogs в client_dialogs.
Также проставляет в camp_dialogs связку с client_dialogs.
Подробности в тикете https://st.yandex-team.ru/DIRECT-97953

=cut

use Direct::Modern;

use Yandex::DBTools;

use Settings;
use ScriptHelper;
use ShardingTools qw/ppc_shards/;
use Yandex::DBShards qw/get_new_id_multi/;

my $CHUNK_SIZE = 300;

#Для тестирования можно запустить скрипт на данные заданных клиентов клиента, указав --clientId=clientId1 --clientId=clientId2
my @clients;
extract_script_params(
    'clientId=s@' => \@clients,
);

$log->out("START");

my $CLIENT_DIALOG_FIELDS = [qw/ClientID skill_id bot_guid name is_active last_sync_time/];
for my $shard (ppc_shards()) {
    $log->msg_prefix("[shard_$shard]");
    # Выбираем из camp_dialogs записи, у которых отсутствует связка с client_dialogs.
    # За раз выбираем по $CHUNK_SIZE штук, пока не закончатся непривязанные записи.
    # is_active не выбираем, т.к. он у всех 1 и он не транслируется однозначно в client_dialogs
   
    my $dialogs;
    while (($dialogs = get_all_sql(PPC(shard => $shard),
        [qq/SELECT
                c.cid,
                c.skill_id,
                c.bot_guid,
                c.name,
                camp.ClientID,
                cl.client_dialog_id as existing_client_dialog_id,
                1 as is_active,
                NOW() as last_sync_time
           FROM camp_dialogs c
                JOIN campaigns camp on (camp.cid = c.cid)
                LEFT JOIN client_dialogs cl on (cl.skill_id = c.skill_id AND camp.ClientID = cl.ClientID)
           /,
           WHERE => {
                'c.client_dialog_id__is_null' => 1,
                (@clients ? ('camp.ClientID' => \@clients) : ()),
           },
           'ORDER BY' => 'c.cid',
           'LIMIT'    => $CHUNK_SIZE
        ])) && @$dialogs){
    
        my %pids_to_resync;
        my ($to_insert, $to_update);
        foreach my $dialog (@$dialogs) {
            unless ($dialog->{existing_client_dialog_id}){
                $to_insert->{_get_client_skill_id($dialog)} //= $dialog;
            }
            else {
                $log->out(sprintf('For cid %s will be set client_dialog_id %s', @$dialog{'cid', 'existing_client_dialog_id'}));
                $to_update->{$dialog->{cid}} = $dialog->{existing_client_dialog_id};
            }
        }
        my $new_ids = get_new_id_multi('client_dialog_id', scalar keys %$to_insert);

        my @insert_data;
        my @cids_without_client_dialog_id;

        foreach my $dialog (values %$to_insert){
            my $client_dialog_id = shift @$new_ids;
            push @insert_data, [$client_dialog_id, @$dialog{@$CLIENT_DIALOG_FIELDS}];
            $log->out(sprintf('Prepared new client_dialog record: client_dialog_id=%s, %s', $client_dialog_id,
                        join(", ",
                            map {$CLIENT_DIALOG_FIELDS->[$_ - 1] ."=". $insert_data[-1]->[$_]} 1 .. scalar @$CLIENT_DIALOG_FIELDS))
            );
            push @cids_without_client_dialog_id, $dialog->{cid};
        }
        if (@insert_data){
            $log->out(sprintf('Inserting prepared %s rows', scalar @insert_data));
            my $i_count = do_mass_insert_sql(PPC(shard => $shard), 'INSERT IGNORE INTO client_dialogs ('.(join ', ', 'client_dialog_id', @$CLIENT_DIALOG_FIELDS).') VALUES %s',
                \@insert_data);
            $log->out(sprintf('%s rows inserted', scalar $i_count));
        }

        #Для кампаний, привязанным к диалогам, отсутствовавшим в client_dialogs перевыберем client_dialog_id, чтобы гарантированно получить правильное значение
        my $cid2client_dialog_id = get_hash_sql(PPC(shard => $shard),
                [qq/SELECT
                    c.cid,
                    cl.client_dialog_id
                FROM camp_dialogs c
                    JOIN campaigns camp on (camp.cid = c.cid)
                    JOIN client_dialogs cl on (cl.skill_id = c.skill_id AND camp.ClientID = cl.ClientID)/,
                WHERE => {
                    'c.cid' => \@cids_without_client_dialog_id
                }
        ]);

        foreach my $cid (keys %$cid2client_dialog_id) {
            $to_update->{$cid} = $cid2client_dialog_id->{$cid};
            $log->out(sprintf('For cid %s will be set client_dialog_id %s', $cid, $to_update->{$cid}));
        }

        $log->out(sprintf('Updating prepared %s rows', scalar keys %$to_update));
        my $u_count = do_mass_update_sql(PPC(shard => $shard), 'camp_dialogs', 'cid', {map {$_ => {client_dialog_id =>$to_update->{$_}}} keys %$to_update});
        $log->out(sprintf('%s rows updated', scalar $u_count));

    }
    $log->out('shard done');
    $log->msg_prefix('');
}

$log->out("FINISH");

sub _get_client_skill_id {
    my ($dialog) = @_;
    return $dialog->{ClientID}.':'.$dialog->{skill_id};
}
