#!/usr/bin/perl

use my_inc "../..";

=head1 DESCRIPTION

Скрипт для разового выставления минимальной ставки АТ для площадки, отключенной для данного АТ через bids_base.opts
Подробности в тикете https://st.yandex-team.ru/DIRECT-96594

=cut

use Direct::Modern;

use Yandex::DBTools;

use Settings;
use ScriptHelper;
use ShardingTools qw/ppc_shards/;
use Currencies qw//;
use BS::ResyncQueue;

#На ppcdev select работает долго, для тестирования можно указать --cid=cid --cid=cid2
my @cids;
extract_script_params(
    'cid=s@' => \@cids,
);

$log->out("START");

for my $shard (ppc_shards()) {
    $log->msg_prefix("[shard_$shard]");
    # Выбираем все не удаленные автотаргетинги, у которых одна из площадок отключена через bids_base.opts,
    # но для нее есть ставка и стратегия не запрещает показы на отключенной площадке.
    # Сразу выбираем и рабочую валюту - она нужна для определения минимальной ставки.
    my $relevance_matches = get_all_sql(PPC(shard => $shard),
        qq/SELECT
                bb.bid_id,
                bb.pid,
                bb.cid,
                bb.price,
                bb.price_context,
                bb.opts,
                FIND_IN_SET("search_stop", bb.opts) as search_stop,
                FIND_IN_SET("net_stop", bb.opts) as net_stop,
                c.platform,
                IFNULL(work_currency, "YND_FIXED") AS work_currency
           FROM clients_options co
                JOIN clients cl on (cl.ClientID = co.ClientID)
                JOIN campaigns c on (co.ClientID=c.ClientID)
                JOIN bids_base bb on (bb.cid = c.cid)
           WHERE
           /.(@cids ?  'c.cid IN ('.(join ', ', map {sql_quote($_)} @cids).') AND ' : '').
           qq/  bb.bid_type='relevance_match'
                AND !FIND_IN_SET("deleted", bb.opts)
                AND (
                    c.platform != 'context' AND  FIND_IN_SET('search_stop', bb.opts) > 0 AND bb.price > 0
                        OR
                    c.platform != 'search' AND  FIND_IN_SET('net_stop', bb.opts) > 0 AND bb.price_context > 0
                )
           ORDER BY bb.pid, bb.bid_id 
        /,
    );

    $log->out(sprintf('%s found', 0 + @$relevance_matches));
    next unless @$relevance_matches;

    # ключи сортируем, чтобы записи в логах выглядели единообразно
    my @keys_sorted = sort keys %{$relevance_matches->[0]};

    my %pids_to_resync;
    foreach my $rm (@$relevance_matches) {
        my $min_price = Currencies::get_currency_constant($rm->{work_currency}, 'MIN_PRICE');
        my %update_data;

        my $current_relevance_match_string = join ' , ', map { $_.': '.$rm->{$_} } @keys_sorted;
        if ( $rm->{net_stop} && $rm->{price_context} > $min_price) {
            $update_data{price_context} = $min_price;
        }
        elsif ($rm->{search_stop} && $rm->{price} > $min_price) {
            $update_data{price} = $min_price;
        }

        if (%update_data) {
            my $changed_values_string = join ', ', map {$_.': '.$update_data{$_}} keys %update_data;
            $log->out("Trying to set [$changed_values_string] for row [$current_relevance_match_string].");
            $update_data{statusBsSynced} = 'No';
            #Т.к число обновляемых записей невелико - от нескольких до пары десятков на шард, просто делаем единичные апдейты
            do_update_table(PPC(shard => $shard), 'bids_base', \%update_data,
                where => {bid_id => $rm->{bid_id}});
            $log->out("row $rm->{bid_id} updated");

            $pids_to_resync{$rm->{pid}} = $rm->{cid}
        }
        else {
            $log->out("Skipping row [$current_relevance_match_string], min_price: $min_price");
        }
    }
    $log->out(sprintf('BS resync for pids: [%s]', join(', ', keys %pids_to_resync)));
    my $resync_count = BS::ResyncQueue::bs_resync([map { {pid => $_, cid => $pids_to_resync{$_}, priority => BS::ResyncQueue::PRIORITY_INTERNAL_REPORTS_LAZY_RESYNC} } keys %pids_to_resync]);
    $log->out("$resync_count rows inserted into ResyncQueue");

    $log->out('shard done');
    $log->msg_prefix('');
}

$log->out("FINISH");
