#!/usr/bin/perl

use my_inc "../..";

=head1 DESCRIPTION

    Очищает tl_id у сайтлинков, скопированных с кампаниий других клиентов.


    LOG_TEE=1 ./protected/one-shot/purge_alien_tl_id_at_sitelinks.pl 

    Параметры (для тестирования):
        client-id -- запустить только для определенного клиента

    Можно перезапускать.

=cut

use Direct::Modern;
use open ':std' => ':utf8';

use Settings;
use ScriptHelper 'Yandex::Log' => 'messages';

use Yandex::DBTools;
use ShardingTools qw/ppc_shards/;
use Sitelinks;


use Try::Tiny qw/try catch/;

# Всего битых сайтлинков порядка 20, чанковать нет смысла
my ($CLIENT_ID);
extract_script_params(
    'client-id:i'  => \$CLIENT_ID,
);
$log->out('START');

my $script_name = get_script_name();
foreach my $shard (ppc_shards()) {
    $log->msg_prefix("shard=$shard");
    $log->out('START');
    my $total = 0;
    try {
        my  $sl_data= get_all_sql(PPC(shard => $shard), [
            'SELECT distinct c.clientId, b.sitelinks_set_id, sl.tl_id
                FROM sitelinks_links sl
                JOIN sitelinks_set_to_link ss ON (ss.sl_id = sl.sl_id)
                JOIN banners b ON (b.sitelinks_set_id = ss.sitelinks_set_id)
                JOIN campaigns c ON (c.cid = b.cid)
                LEFT JOIN turbolandings t ON (t.tl_id = sl.tl_id)',
                WHERE => {
                    ($CLIENT_ID ? ('c.ClientID' => $CLIENT_ID) : ()),
                    'sl.tl_id__gt' => 0,
                    _TEXT => 'c.clientId != COALESCE(t.ClientId, 0)'
                },
                'ORDER BY' => 'c.ClientID'
        ]);

        $log->out((scalar @$sl_data)." broken sitelink links found");
        
        my $ss_info;
        foreach my $row (@$sl_data) {
                my $client_id = $row->{clientId};
                my $tl_id = $row->{tl_id};
                my $ss_id = $row->{sitelinks_set_id};

                $ss_info->{$ss_id}->{client_id} //= $client_id;
                $ss_info->{$ss_id}->{$tl_id} //= $tl_id;

                $log->out("Preparing to purge sitelink_set: $ss_id, turbolanding: $tl_id, client: $client_id");
        }
        _purge_tl_ids($shard, $ss_info) if $ss_info;
        
        $log->out('FINISH');
    }
    catch {
        $log->out( join "\n", @_);
        die;
    };
}

$log->out('FINISH');

sub _purge_tl_ids {
    my ($shard, $ss_info, $total_ref) = @_;

    my $new_sitelink_set_id;
    my $sitelinks_data = Sitelinks::get_sitelinks_by_set_id_multi([keys %$ss_info]);
    foreach my $old_ss_id (keys $sitelinks_data) {
        my $sitelinks_set = $sitelinks_data->{$old_ss_id};
        my $client_id = $ss_info->{$old_ss_id}->{client_id};

        foreach my $sitelink (@$sitelinks_set) {
            #Sitelinks::get_sitelinks_by_set_id_multi делает left join turbolandings
            #Поэтому, если чужие турболендинги на другом шарде - их не будет в результатах чтения
            next unless exists $sitelink->{turbolanding};
            my $tl_id = $sitelink->{turbolanding}->{id};
            #Если у сайтлика есть турболендинг и он в списке тех, которые нужно очистить - очищаем
            if ($tl_id && $ss_info->{$old_ss_id}->{$tl_id}) {
                delete $sitelink->{turbolanding};
                $log->out("Purged turbolanding: $tl_id, : $client_id");
            }
        }
        my $new_ss_id = Sitelinks::save_sitelinks_set($sitelinks_set, $client_id);
        if ($new_ss_id != $old_ss_id) {
            #По sitelinks_set_id в banners есть индекс, так что можно не доставать bid
            #В БК не переотправляем т.к. в первую очередь аффектится интерфейс.
            do_update_table(PPC(shard => $shard), 'banners', {sitelinks_set_id => $new_ss_id},
                        where => {sitelinks_set_id => $old_ss_id} );
            $log->out("Fixed. Source sitelink set: $old_ss_id,  new id: $new_ss_id, client: $client_id");
        }
        else {
            $log->out("Skipped. Sitelink set: $old_ss_id, client: $client_id");
        }
    }
}
