#!/usr/bin/perl

#Удаление дублей автотаргетинга 
use my_inc '../..';

use Direct::Modern;
use Settings;
use ScriptHelper;

use Yandex::DBTools;
use Yandex::Retry qw/relaxed/;
use Yandex::HashUtils qw/hash_cut/;

my $SLEEP_COEF = 1;

extract_script_params(
    'sleep-coef=i' => \$SLEEP_COEF,
);

my $AFFECTED_PIDS = [
    3346171673,
    3346171674,
    3346171675,
    3346171677,
    3346171679,
    3346171682,
    3346171684,
    3346171685,
    3346171689,
    3346171691,
    3346171696,
    3346171704,
    3346171711,
    3346171713,
    3346171715,
    3346171716,
    3346171718,
    3346171719,
    3346171720,
    3346171722,
    3346171728,
    3346171729,
    3346171731,
    3346171733,
    3346171736,
    3346171739,
    3346171741,
    3346171742,
    3346171746,
    3346171748,
    3346171749,
    3346171750,
    3346171751,
    3346171753,
    3346171754,
    3346171755,
    3346171756,
    3346171757,
    3346171758,
    3346171759,
    3346171762,
    3346171763,
    3346171767,
    3346171772,
    3346171776,
    3346171778,
    3346171784,
    3346171785,
    3346171787,
    3346171791,
    3346171794,
    3346171796,
    3346171798,
    3346171800,
    3346171802,
    3346171803,
];

$log->out(sprintf('START: chunk rest coefficient %s', $SLEEP_COEF));

$log->out('BEGIN');

foreach my $pid (@$AFFECTED_PIDS) {
    relaxed times => $SLEEP_COEF, sub {
        my $relevance_matches = get_all_sql(PPC(shard => 1),
                ['SELECT bid_id, bid_type, price, price_context, autobudgetPriority, opts FROM bids_base',
                  WHERE => {pid => $pid, bid_type=>'relevance_match'},
                  'ORDER BY' => 'bid_id'
                ] 
        );
        unless (@$relevance_matches == 2 ) {
            $log->out(sprintf('pid %s - found %s relevance matches instead 2, skipping...', $pid, scalar @$relevance_matches));
        }
        else {
            my ($old, $new) = @$relevance_matches;
            my $count;
            do_in_transaction {
                $log->out(sprintf('pid %s - deleting record ', $pid).join(', ', map {$_.' : '.($new->{$_} // '')} qw/bid_id bid_type price price_context autobudgetPriority opts/));
                $count = do_sql(PPC(shard => 1), ['DELETE FROM bids_base', WHERE => {bid_id => $new->{bid_id}, pid => $pid, bid_type => 'relevance_match'}]);
                $log->out(sprintf('%s rows deleted', $count));

                my $new_values = hash_cut($new, [qw/price price_context autobudgetPriority opts/]);
                $new_values->{statusBsSynced} = 'No';
                $log->out(sprintf('pid %s - updating record ', $pid)
                    .'['.join(', ', map {$_.' : '.($old->{$_} // '')} qw/bid_id bid_type price price_context autobudgetPriority opts/).']'
                    .' -> '
                    .'['.join(', ', ( 'bid_id'.' : '.$old->{bid_id}, map {$_.' : '.($new_values->{$_} // '')} qw/bid_type price price_context autobudgetPriority opts statusBsSynced/)).']'
                );

                $count = do_update_table(PPC(shard => 1), 'bids_base', $new_values,
                        where => {bid_id => $old->{bid_id}, pid => $pid, bid_type => 'relevance_match'});
                $log->out(sprintf('%s rows updated', $count));
                
                $log->out(sprintf('Updating statusBsSynced for adgroup %s', $pid));
                $count = do_update_table(PPC(shard => 1), 'phrases', {statusBsSynced => 'No', LastChange__dont_quote => 'NOW()'},
                        where => {pid => $pid, statusBsSynced__ne => 'No'});
                $log->out(sprintf('%s rows updated', $count));
            };
        }
    };
}
$log->out('FINISH');
