#!/usr/bin/perl

use my_inc '../..';


=head1 NAME

remove_manual_banner_permalinks_by_bid.pl

=head1 DESCRIPTION

Скрипт удяляет вручную созданные связки баннер-пермалинк по bid

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;
use Moderate::ResyncQueue;

use Path::Tiny;

use ScriptHelper;
use Settings;
use ShardingTools qw/ppc_shards/;

my $data_path;
extract_script_params('data-file=s' => \$data_path);
my @bids = path($data_path)->lines({ chomp => 1});
$log->die("Can't open data file $data_path: $@") if !@bids;

$log->out('START');
for my $shard (ppc_shards()) {
    my $log_prefix_guard = $log->msg_prefix_guard("[shard $shard]");
    for my $chunk(chunks(\@bids, 1000)) {
        $log->out("deleting permalink links for bids " . join(',', @$chunk));
        my $result = do_sql(PPC(shard => $shard), 
               [
                   "DELETE FROM banner_permalinks",
                   WHERE => {bid__in => $chunk, permalink_assign_type => 'manual'}
               ]);
        $log->out("deleted $result rows");
    }
}

$log->out('Adding banners to moderation queue');
my @objects;
for my $bid ( @bids ) {
    push @objects, {
        id         => $bid,
        type       => 'banner',
        priority   => 50,
        remoderate => 0,
    };
}
Moderate::ResyncQueue::mod_resync( \@objects, log => $log );

$log->out('FINISH');
