#!/usr/bin/perl

use my_inc "../..";


=head1 NAME

    resend_unmoderated_phrases

=head1 SYNOPSIS

    resend_unmoderated_phrases.pl --limit=15000 --chunk-size=100 --sleep=60
        Пометит как готовые к отправке на модерацию не более 15_000 групп (в каждом шарде), помечая за раз 100 штук, делая паузы в 60 секунд

    Можно указать --limit=0 для обработки всех групп.

=head1 DESCRIPTION

    Повторная отправка на модерацию групп, помеченных как принятые/отклоненные,
        но содержащих непромодерированные фразы

=cut

use strict;
use warnings;

use lib::abs '..';

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Yandex::ListUtils qw/chunks/;
use ShardingTools;

use utf8;

my ($CHUNK_SIZE, $LIMIT, $SLEEP);
extract_script_params(
    "chunk-size=i"  => \$CHUNK_SIZE,
    "sleep=i"       => \$SLEEP,
    "limit=i"       => \$LIMIT,
);

usage() && exit unless $CHUNK_SIZE && defined $LIMIT && $SLEEP;

$log->out('START');

my ($total_pids, $updated) = (0, 0);
for my $shard (ppc_shards()) {
    my $broken_pids = get_one_column_sql(PPC(shard => $shard), [q/
        SELECT STRAIGHT_JOIN DISTINCT bi.pid
          FROM bids bi
               JOIN phrases p ON p.pid = bi.pid
         WHERE bi.statusModerate = 'New'
               AND p.statusModerate IN ('Yes', 'No')
       /,
       $LIMIT ? qq/LIMIT $LIMIT/ : (),
    ]) || [];
    $total_pids += scalar @$broken_pids;

    foreach my $chunk (chunks ($broken_pids, $CHUNK_SIZE)) {
        $log->out(q/Set statusModerate = 'Ready' for pids: / . join (',', @$chunk));

        my $count = do_update_table(PPC(shard => $shard),
            'phrases',
            { statusModerate => 'Ready' },
            where => {
                pid => $chunk,
                'statusModerate__in' => ['Yes', 'No'],
            }
        );
        $updated += $count eq '0E0' ? 0 : $count;
        sleep $SLEEP;
    }
}

$log->out("Found: $total_pids pids \tUpdated: $updated pids");
$log->out('FINISH');
