#!/usr/bin/perl

use my_inc '../..';

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::DBShards;

use List::Util qw(min);

use Settings;
use ScriptHelper;
use ShardingTools;

my $CHUNK_SIZE = 10_000;

$log->out('START');

my %cond = (
    'c.archived' => 'Yes',
    'b.statusActive' => 'Yes',
);

foreach_shard shard => [ppc_shards()], sub {
    my ($shard) = @_;
    $log->msg_prefix("[shard $shard]");

    my $total_fixed_cnt = 0;
    my ($min_bid, $max_bid) = get_one_line_array_sql(PPC(shard => $shard), 'SELECT MIN(bid), MAX(bid) FROM banners');
    $log->out("Min bid is $min_bid, max -- $max_bid");
    for (my $bid_first = $min_bid; $bid_first <= $max_bid; $bid_first += $CHUNK_SIZE) {
        my $bid_last = min $max_bid, $bid_first + $CHUNK_SIZE - 1;
        $log->out("Fetching banners to fix statusActive for bids [$bid_first;$bid_last]");
        my $bids = get_one_column_sql(PPC(shard => $shard), ['
            SELECT b.bid
            FROM campaigns c
            INNER JOIN phrases p ON c.cid = p.cid
            INNER JOIN banners b ON p.pid = b.pid
        ',  WHERE => {
                'b.bid__between' => [$bid_first, $bid_last],
                %cond,
        }]) || [];
        $log->out('Got ' . scalar(@$bids) . ' banners to fix');

        $log->out('Fixing bids:', $bids);
        $total_fixed_cnt += do_sql(PPC(shard => $shard), ['
            UPDATE banners b
            INNER JOIN phrases p ON p.pid = b.pid
            INNER JOIN campaigns c ON p.cid = c.cid
            SET b.statusActive = "No"
              , b.LastChange=b.LastChange
        ',  WHERE => {%cond, 'b.bid' => $bids}]);
    }
    $log->out("Fixed total $total_fixed_cnt banners");
};
$log->msg_prefix('');

$log->out('FINISH');
