#!/usr/bin/perl

# статистика по решардингу - можно узнать, сколько примерно строк и какой объём данных
# был перенесён за последние N дней

use Direct::Modern;
use List::Util qw/sum/;

use Yandex::DBTools;

use my_inc '../..';

use ScriptHelper;
use Settings;

my $DAYS = 7;
my $LIMIT = 1e6;
my $SHARD = 1;
extract_script_params(
    "days=i" => \$DAYS,
    "limit=i" => \$LIMIT,
    );

my %TABLES = (
    (map { $_ => "SELECT STRAIGHT_JOIN count(*) FROM campaigns c join $_ using(cid) WHERE c.ClientID = ?" } qw/campaigns banners phrases bids bids_arc bids_phraseid_associate/),
    );

my $reshards = get_all_sql(PPCDICT, "SELECT ClientID, old_shard, new_shard FROM reshard_queue WHERE done_time >= now() - interval ? day and old_shard = ? limit ?", $DAYS, $SHARD, $LIMIT);

my %PER_TABLE;
for my $reshard_item (@$reshards) {
    my $ClientID = $reshard_item->{ClientID};
    $log->out("get client stat for $ClientID");
    for my $tbl (keys %TABLES) {
        my $cnt = get_one_field_sql(PPC(ClientID => $ClientID), $TABLES{$tbl}, $ClientID);
        $PER_TABLE{$tbl} += $cnt;
    }
}

my $table_info = get_hashes_hash_sql(PPC(shard => $SHARD), "select table_name, avg_row_length as row_sz, data_length+index_length as sz from information_schema.tables");

my $tbls_size = sum map {$table_info->{$_}->{sz}} keys %TABLES;

my $all_rows = 0;
my $all_size = 0;
for my $tbl (sort keys %TABLES) {
    my $rows = $PER_TABLE{$tbl};
    printf "%s:\trows: %d, size: %d\n", $tbl, $rows, $rows*$table_info->{$tbl}->{row_sz};
    $all_rows += $rows;
    $all_size += $rows * $table_info->{$tbl}->{row_sz};
}
print "===\n";
printf "Total: shard=$SHARD,clients=%d, rows=%d, size=%0.3fG (%0.2f%%)\n\n", scalar(@$reshards), $all_rows, $all_size/(2**30), 100 * $all_size / $tbls_size;

sub calc_client_stat {
    my ($ClientID) = @_;
    my %stats;
    return \%stats;
}
