#!/usr/bin/perl

use my_inc "../..";


=head1 NAME

    reshard-user.pl - перенос всех данных клиента в другой шард

=head1 DESCRIPTION

    reshard-user.pl --login my_favorite_client_login --shard 2
    Параметры:
     --login <LOGIN> - обязательный, логин переносимого клиента
     --block - блокировать пользователя на время переноса
     --block-sleep N - после блокироки - пауза N секунд
     --shard <SHARD> - обязательный, в какой шард переносим клиента
    
     --simulate - делать только выборки, без реального переноса
     --log-data - логировать все выбранные строки
     --no-validate-db-schema - не проверять на соответствие данным из db_schema
     --transaction-per-table - работать не в единой транзакции, а создавать транзакцию для каждой таблицы

=cut

use strict;
use warnings;

use Carp qw/croak/;

use Yandex::DBShards;

use lib::abs '..';

use Settings;
use PrimitivesIds;
use ScriptHelper get_file_lock => undef;
use Direct::ReShard;

use utf8;
use open ':std' => ':utf8';
$|++;

my ($LOGIN, $SHARD, $SIMULATE, $BLOCK, $BLOCK_SLEEP);
my $LOG_DATA = 1;
my $VALIDATE_DB_SCHEMA = 1;
my $TRANSACTION_PER_TABLE = 0;
extract_script_params(
    "login=s" => \$LOGIN,
    "block!" => \$BLOCK,
    "block-sleep=i" => \$BLOCK_SLEEP,
    "shard=i" => \$SHARD,

    "simulate!" => \$SIMULATE,
    "validate-db-schema!" => \$VALIDATE_DB_SCHEMA,
    "transaction-per-table!" => \$TRANSACTION_PER_TABLE,
    "log-data!" => \$LOG_DATA,
);

if (!defined $LOGIN) {
    usage("Parameter --login is not defined");
} elsif (!defined $SHARD) {
    usage("Parameter --shard is not defined");
}
#die "not for production now" if is_production();
PPC(shard => $SHARD);

my $ClientID = get_clientid(login => $LOGIN) || croak "Client for user $LOGIN is not found";
my $old_shard = get_shard(ClientID => $ClientID);

if ($old_shard == $SHARD) {
    print STDERR "User $LOGIN already in shard $SHARD\n";
    exit 0;
}

my $resharder = Direct::ReShard->create(
    simulate => $SIMULATE,
    log_data => $LOG_DATA,
    validate_db_schema => $VALIDATE_DB_SCHEMA,
    transaction_per_table => $TRANSACTION_PER_TABLE,
);

# блокировка
my $lock_data;
if (!$SIMULATE && $BLOCK) {
    $lock_data = $resharder->get_lock_client_data($ClientID, $old_shard);
    $resharder->lock_client($ClientID, $old_shard, $lock_data);
    sleep $BLOCK_SLEEP if $BLOCK_SLEEP;
}

# перенос
$resharder->logger->{tee} = 1 if $ENV{LOG_TEE};
$resharder->move_client_data($ClientID, $old_shard, $SHARD);

# разблокировка
if (!$SIMULATE && $BLOCK) {
    $resharder->unlock_client($ClientID, $SHARD, $lock_data);
}

