#!/usr/bin/perl

use my_inc "../..";

use Direct::Modern;

use Yandex::DBShards;
use File::Slurp qw/read_file/;
use JSON;
use List::MoreUtils qw/uniq/;

use Direct::AdGroups2::Text;
use Direct::Banners::Text qw//;
use Direct::Model::VideoAddition;
use Direct::Model::BannerCreative;

use Settings;
use ScriptHelper;

my $FILE;
extract_script_params(
    'bids-creatives-file=s' => \$FILE,
);

$log->out("START");

$log->out("read bindings from file '$FILE'");

die 'unknown file $FILE' unless -f $FILE;

my $bindings = read_file($FILE);
my $bids_creatives = from_json($bindings);
foreach_shard(bid => $bids_creatives, by => sub { $_->[0] }, chunk_size => 1000, sub {

    my ($shard, $bids_creatives_chunk) = @_;

    my %bid_creative_id = map { $_->[0] => $_->[1] } @$bids_creatives_chunk;

    my $banners = Direct::Banners::Text->get_by(
        banner_id => [keys %bid_creative_id],
        with_vcard => 1,
        with_sitelinks => 1,
        with_image => 1,
        with_roles => [qw/Direct::Model::Role::OnlyBannersResources/],
        with_video_resources => 1,
        with_catalogia_rubrics => 1,
        filter => {
            statusArch => 'No',
        }
    )->items;

    $banners = [ grep { !$_->has_creative } @$banners ];
    return unless @$banners;

    $log->out("$#$banners banners to process");

    my $adgroups = Direct::AdGroups2::Text->get([uniq map { $_->adgroup_id } @$banners], extended => 1)->items_by('id');
    for my $banner (@$banners) {
        $banner->old($banner->clone);
        $banner->adgroup($adgroups->{$banner->adgroup_id});

        $log->out(sprintf "set %d-%d", $banner->id, $bid_creative_id{$banner->id});

        my $creative = Direct::Model::VideoAddition->new(
            id => $bid_creative_id{$banner->id},
            resource_type => 'creative',
        );
        my $banner_creative = Direct::Model::BannerCreative->new(id => 0, creative => $creative);
        $banner->creative($banner_creative);
    }

    my $logic = Direct::Banners::Text->new(items => $banners);
    $logic->update(1);

    $log->out("updated $#$banners banners");
});

$log->out("FINISH");
