#!/usr/bin/perl

use my_inc "../..";


=head1 DESCRIPTION

Выключние показов на поиске для смарт-кампаний, которым показы на поиске были подключены автоматически

=cut

use Direct::Modern;

use Yandex::ListUtils qw/chunks/;
use Try::Tiny qw/try catch/;

use Settings;
use ScriptHelper;
use Direct::Campaigns::Performance;
use Path::Tiny qw/path/;

my $CHUNK_SIZE = 500;
my $NEW_PLATFORM = 'context';

$log->out("START");
my $data = path(my_inc::path('../../deploy/restore_platform_for_perf_camps.data'))->slurp;
my $cids = [map { $_ =~ s/\D+//gr } split /\n/, $data];
die 'Do nothing' unless @$cids;

restore_platform($cids);
$log->out("FINISH");


sub restore_platform {
    my ($all_cids) = @_;

    foreach my $chunk (chunks($all_cids, $CHUNK_SIZE)){
    	try {
        	_update_strategy($chunk);
        }
        catch {
        	my $error = shift;
        	$log->out("Got error: ".$error);
        };
    }
}

sub _update_strategy {
    my ($cids) = @_;

    $log->out("Processing cids: ", join( ', ', @$cids));

    my $campaigns = Direct::Campaigns::Performance->get($cids);
    foreach my $camp (@{$campaigns->items}){
        my $old_platform = $camp->platform;
	if ($old_platform ne 'both'){
		$log->out("Campaign ".$camp->id()." skipped. Platform ->".$old_platform);
	}
	else{
		$log->out("Campaign ".$camp->id()." going to change platform: $old_platform -> ".$NEW_PLATFORM);
        	$camp->platform($NEW_PLATFORM);
        	$log->out("Campaign ".$camp->id()." platform changed: $old_platform -> ".$camp->platform());
        	$camp->status_bs_synced('No');
        	$camp->do_update_last_change(1);
	}
    }

    $campaigns->save();
    
    return;
}
    
