#!/usr/bin/perl

#Переотправка в БК всех баннеров с permalink'ами после перепривязки permalink'ов из справочника
use my_inc '../..';

use Direct::Modern;
use Settings;
use ScriptHelper;
use ShardingTools;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Retry qw/relaxed/;
use BS::ResyncQueue;

my $SLEEP_COEF = 1;
my $CHUNK_SIZE = 10_000;
my $SHARD;

extract_script_params(
    'sleep-coef=i' => \$SLEEP_COEF,
    'chunk-size=i' => \$CHUNK_SIZE,
    'shard=i' => \$SHARD,
);

$log->out(sprintf('START: chunk size %s, rest coefficient %s', $CHUNK_SIZE, $SLEEP_COEF));
foreach_shard_parallel( (shard => [$SHARD // ppc_shards()]), sub {
        my ($shard) = @_;

        local $SIG{__DIE__} = sub { local $log->{msg_prefix} = undef; $log->die({ message => 'DIED!', error => $_[0], shard => $shard }); };

        my $guard = $log->msg_prefix_guard("[shard_$shard]");

        $log->out('BEGIN');
        my $max_bid = 0;

        while (my $resync_data = get_all_sql(PPC(shard => $shard), [
                'SELECT b.cid, b.bid, ? AS priority
                    FROM banner_permalinks p JOIN banners b ON (b.bid = p.bid)',
                    WHERE => {
                        'p.bid__gt' => $max_bid,
                        'b.statusBsSynced__ne' => 'No',
                    },
                    'ORDER BY' =>  'p.bid',
                    'LIMIT' => $CHUNK_SIZE
                ], BS::ResyncQueue::PRIORITY_UPDATE_PERMALINKS )
            ){
                last unless @$resync_data;
                relaxed times => $SLEEP_COEF, sub {
                    $max_bid = $resync_data->[-1]->{bid};
                    $log->out("Select $CHUNK_SIZE from bid $max_bid");
                    my $resend_cnt = bs_resync($resync_data);
                    $log->out("$resend_cnt banners added into BS resync queue");
                };
            }
            $log->out('SHARD COMPLETED');
        }
);

$log->out('FINISH');
