#!/usr/bin/perl

use Direct::Modern;

use my_inc '../..';
use feature 'state';
use Settings;
use Yandex::DBTools;
use ScriptHelper;
use ShardingTools qw/ppc_shards/;
use Direct::Creatives qw//;
use BannerStorage qw//;
use Direct::Model::Creative::Manager qw//;

use constant SELECT_FOR_ONCE => 100;

$log->out('START');

for my $shard (ppc_shards()) {
    $log->msg_prefix("shard:$shard");
    while (my $creatives = get_next_creatives($shard)) {
        $log->out(sprintf "selected %d creatives", @$creatives + 0);
        sync_creative_reasons($shard => $creatives);
    }
}

$log->out('FINISH');

sub get_next_creatives {
    my $shard = shift;

    state $state_shard;
    state $last_id;
    if (!defined $state_shard || $state_shard != $shard) {
        $last_id = 0;
        $state_shard = $shard; 
    }

    my $creatives = get_all_sql(PPC(shard => $state_shard),
        ["SELECT creative_id, ClientID AS client_id FROM perf_creatives",
            WHERE => { 
                creative_id__gt => $last_id,
                statusModerate => 'No'
            },
            "ORDER BY creative_id",
            LIMIT => SELECT_FOR_ONCE]);
    $last_id = $creatives->[-1]->{creative_id} if @$creatives; 

    return @$creatives == 0 ? undef : $creatives;
}


sub sync_creative_reasons {
    my ($shard, $sync_creatives) = @_;

    my ($creative_ids, $creative2client) = Direct::Creatives::_extract_client_ids($sync_creatives);
    my $creatives = BannerStorage::receive_creatives($creative_ids);

    my @declined_creatives;
    foreach my $c (@$creatives) {
        if ($c->status_moderate eq 'No') {
            $c->client_id($creative2client->{$c->id});
            push @declined_creatives, $c;
        } else {
            $log->out(sprintf "skip creative %d (banner store moderation is %s)", $c->id, $c->status_moderate);
        }
    }

    return unless @declined_creatives;

    my (@edited_creatives, @actual_creatives);
    do_in_transaction {
        my $ids = [map { $_->id } @declined_creatives];
        my $sent_creatives = get_hash_sql(PPC(shard => $shard), [
            "SELECT creative_id FROM perf_creatives",
            WHERE => {creative_id => $ids, statusModerate => 'No'},
            "FOR UPDATE"
        ]);
        for my $c (@declined_creatives) {
            if (exists $sent_creatives->{$c->id}) {
                push @actual_creatives, $c;
            } else {
                push @edited_creatives, $c;
            }
        }
        Direct::Model::Creative::Manager->new(items => \@actual_creatives)->create_or_update;
    };
    for my $c (@edited_creatives) {
        $log->out(sprintf "skip creative %d (it already edited)", $c->id);
    }
    for my $c (@actual_creatives) {
        $log->out(sprintf "sync creative %d (set reasons %s)", $c->id, join ',', $c->rejection_reason_ids);
    }
}
