#!/usr/bin/perl

=head2 NAME

    change-manager-to-agency-inplace.pl

=head2 DESCRIPTION

    Скрипт сервисирования всех (text, wallet) самостоятельных кампаний клиента.
    По смыслу реализует то же, что ручка "администрирование " - "сменить менеджера на кампании",
    но умеет это делать сразу для всех кампаний.

    Принцип работы: получить все свободные кампании и позвать на каждую send_camp_to_service.

    Принимает следующие параметры:
    --login         - логин клиента (можно указывать несколько раз)
    --manager-login - логин менеджера, на сервисирование которому будут переведены кампании
    --force         - для принудительного перевода не сервесирование, без "offer&accept"

=cut

use my_inc "../..";

use strict;
use warnings;
use utf8;

use Yandex::DBTools;

use Settings;
use ScriptHelper;

use Campaign;;
use PrimitivesIds;
use RBAC2::Extended;
use RBACElementary;

my ($MANAGER_LOGIN, @LOGINS, $FORCE);

extract_script_params(
    'login=s' => \@LOGINS,
    'force' => \$FORCE,
    'manager-login=s' => \$MANAGER_LOGIN,
);

my $OPERATOR_UID = 1;

$log->out('START');
$log->out({
    'login' => \@LOGINS,
    'force' => $FORCE,
    'manager-login' => $MANAGER_LOGIN,
});

my $rbac = eval { RBAC2::Extended->get_singleton($OPERATOR_UID) }
    or $log->die("Can't connect to RBAC: $@");

my $MANAGER_UID = get_uid(login => $MANAGER_LOGIN);
$log->die('Manager is not defined') unless $MANAGER_UID;

for my $login (@LOGINS) {
    my $CLIENT_CLIENTID = get_clientid(login => $login);
    my $CLIENT_CHIEF_UID = rbac_get_chief_rep_of_client($CLIENT_CLIENTID);
    $log->out({
        'login' => $login,
        'client-clientid' => $CLIENT_CLIENTID,
        'client-chief-uid' => $CLIENT_CHIEF_UID,
        'manager-uid' => $MANAGER_UID,
    });

    $log->die('Client is not defined') unless $CLIENT_CLIENTID && $CLIENT_CHIEF_UID;

    $log->out('fetch camps list');
    my $camps_to_service = get_one_column_sql(PPC(ClientID => $CLIENT_CLIENTID), [
                                                    'SELECT cid FROM campaigns',
                                                    WHERE => [
                                                        uid => $CLIENT_CHIEF_UID,
                                                        _OR => [
                                                            ManagerUID => 0,
                                                            ManagerUID__is_null => 1,
                                                        ],
                                                        _OR => [
                                                            AgencyUID => 0,
                                                            AgencyUID__is_null => 1,
                                                        ],
                                                        AgencyID => 0,
                                                        type => ['text', 'wallet'],
                                                        statusEmpty => 'No',
                                                    ],
                                              ]);
    $log->out(camps_to_service => $camps_to_service);

    for my $cid (@$camps_to_service) {
        $log->out("send camp $cid to service");
        my $res = eval {
            send_camp_to_service($rbac, $cid, $CLIENT_CHIEF_UID, $MANAGER_UID, force => $FORCE);
            return 1;
        };
        if (!$res || $@) {
            $log->die($@);
        }
    }
}

$log->out('FINISH');
