#!/usr/bin/perl

use my_inc "../..";

=head1 NAME

    set-common-ci.pl

=head2 DESCRIPTION

    Скрипт предназначен для установки единой визитки (по образцу) на все неархивные кампании клиента
    Установка производится по принципу ЕКИ - на все неархивные баннеры. 
    Принимает параметры:
        --vcard_id  - номер визитки образца,
        --uid       - uid владельца кампаний, которым нужно установить визитку.

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBShards;
use Yandex::DBTools;
use Yandex::Validate;

use Settings;
use CommonMaps;
use MailNotification;
use PrimitivesIds;
use ScriptHelper;
use VCards;


my ($vcard_id, $uid);
extract_script_params(
    'vcard_id=i'    => \$vcard_id,
    'uid=i'         => \$uid,
);

# simple validation
unless (is_valid_id($vcard_id)) {
    die 'vcard_id has invalid value or not specified';
}
unless (is_valid_id($uid)) {
    die 'uid has invalid value or not specified';

}


$log->out('START');

my $ClientID = get_clientid(uid => $uid);
my $vcard = get_one_vcard($vcard_id);
my $cids = get_one_column_sql(PPC(uid => $uid), ['SELECT cid FROM campaigns', WHERE => {
    uid         => SHARD_IDS,
    archived    => 'No',
    statusEmpty => 'No',
}]);

# data validation
unless ($ClientID) {
    $log->die("No ClientID found for uid $uid");
}
unless (%$vcard) {
    $log->die("Vcard with vcard_id $vcard_id was not found");
}
unless (@$cids) {
    $log->die("Campaigns not found for uid $uid");
}

MailNotification::save_UID_host($uid); # save for MailNotification::mail_notification

$log->out({original_vcard => $vcard});
$vcard->{ClientID} = $ClientID;
my $smap = CommonMaps::check_address_map($vcard, {ClientID => $ClientID}) || {};
$log->out({address_checking_result => $smap});
$vcard->{address_id} = $smap->{aid};

$log->out({vcard_to_apply => $vcard});
$log->out({campaigns_list => $cids});

my ($i, $total) = (0, scalar(@$cids));
for my $cid (@$cids) {
    ++$i;
    $log->out("Setting common contactinfo for camp $cid [$i / $total]");
    # делаем копию, потому что внутри VCards::_reformat_phone правится исходный хеш!
    # и на второй и последующих кампаниях телефон получался вида +7800 780 7..
    my %vcard_to_apply = %$vcard;
    set_common_contactinfo($cid, \%vcard_to_apply, $uid);
}

$log->out('FINISH');
