#!/usr/bin/perl

=head1 DESCRIPTION

Скрипт для ручной установки креатива баннеру

Параметры:
  --bid <bid>
  --creative_id <creative_id>

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '../..';

use ScriptHelper;
use Settings;
use PrimitivesIds qw/get_cid get_pid/;

$log->out('START');

my $bid;
my $creative_id;

extract_script_params('bid=s' => \$bid, 'creative_id=s' => \$creative_id);

my $cid = get_cid(bid => $bid) or die "invalid bid";
my $pid = get_pid(bid => $bid) or die "invalid bid";

$log->out(['previous record', get_one_line_sql(PPC(bid => $bid), ['select * from banners_performance', where => { bid => $bid }]) ]);

my $banner_creative_id = get_one_field_sql(PPC(bid => $bid), ['select banner_creative_id from banners_performance', where => { bid => $bid, pid => $pid, cid => $cid }])
    || get_new_id('banner_creative_id');

$log->out({ banner_creative_id => $banner_creative_id, cid => $cid, pid => $pid, bid => $bid, creative_id => $creative_id });

do_insert_into_table(PPC(bid => $bid), 'banners_performance', {
    banner_creative_id => $banner_creative_id,
    cid => $cid,
    pid => $pid, 
    bid => $bid,
    creative_id => $creative_id,
    statusModerate => 'Yes',
}, on_duplicate_key_update => 1);

do_update_table(PPC(bid => $bid), 'banners', { statusBsSynced => 'No' }, where => { bid => $bid });

$log->out('FINISH');

