#!/usr/bin/perl

use my_inc "../..";

=head1 DESCRIPTION

    Установка ID креатива на котором находятся ресурсы для показа

    Параметры:

        only-shards   -- список шардов, на которых запускать (через запятую)
        chunk-size    -- сколько кампаний обрабатывать за раз (5 000 по умолчанию)

    Можно перезапускать.

=cut

use Direct::Modern;
use open ':std' => ':utf8';

use ScriptHelper 'Yandex::Log' => 'messages';

use Yandex::DBTools;
use Yandex::DBShards;
use ShardingTools qw/ppc_shards foreach_shard_parallel_verbose/;
use Settings;

my ($ONLY_SHARDS, $CHUNK_SIZE);
extract_script_params(
    'only-shards:s' => \$ONLY_SHARDS,
    'chunk-size:i'  => \$CHUNK_SIZE,
);

$CHUNK_SIZE ||= 5_000;
die "No valid chunk-size specified" if $CHUNK_SIZE < 1;

$log->out('START');

my @shards = defined $ONLY_SHARDS ? grep { /^\d+$/ } (split /,/, $ONLY_SHARDS) : ppc_shards();
die "No valid shards specified" unless @shards;
$log->out("Running on shards: ". join ',', @shards);

foreach_shard(shard => \@shards, sub {
    my ($shard) = @_;
    $log->msg_prefix("[shard:$shard]");
    while (my $creative_ids = get_next_creatives($shard)) {
        $log->out(sprintf("set stock_creative_id for %d items: ", @$creative_ids + 0), join ",", @$creative_ids);
        do_sql(PPC(shard => $shard),
               ["UPDATE perf_creatives SET stock_creative_id = creative_id",
                WHERE => {
                    creative_id => $creative_ids,
                    stock_creative_id__is_null => 1
                }]);
    }
});


sub get_next_creatives {

    my $shard = shift; 

    state $last_creative_id = 0;
    state $last_shard = 0;
    $last_creative_id = 0 if $last_shard != $shard;

    my $ids = get_one_column_sql(
                 PPC(shard => $shard),
                 "select creative_id from perf_creatives where creative_id > ? AND stock_creative_id IS NULL ORDER BY creative_id LIMIT ?",
                 $last_creative_id, $CHUNK_SIZE);
    $last_shard = $shard;
    $last_creative_id = $ids->[-1] if @$ids;
    return @$ids ? $ids : undef;
}


$log->out('FINISH');


