#!/usr/bin/perl

use my_inc '../..';

use Direct::Modern;
use Yandex::DBTools;

use ScriptHelper;
use Settings;
use ShardingTools qw(ppc_shards);

my $DRY_RUN;
extract_script_params(
    'dry-run'       => \$DRY_RUN
);

$log->out('START');

for my $shard (ppc_shards()) {
    $log->out("updating shard: $shard");

    do_in_transaction {
        my $cids = get_one_column_sql(PPC(shard => $shard), ["select cid from campaigns c join camp_options co using (cid)",
            WHERE => {
                "c.strategy_name" => "default",
                "c.platform"      => "search",
                "co.strategy"     => "different_places"
            },
            'FOR UPDATE',
        ]);

        if (@$cids) {
            $log->out("fix camp_options.strategy for cids: @$cids");
        } else {
            $log->out("nothing to update");
        }

        unless ($DRY_RUN) {
            my $cnt = do_sql(PPC(shard => $shard), [ "update camp_options set strategy= NULL",
                "where" => { "cid" => $cids } ]);

            $log->out("update $cnt rows");
        }
    }
}

$log->out('FINISH');
