#!/usr/bin/make -sf

# Зачем нужен этот makefile:
# Каталог с данными базы ppcmonitor нужно разделить на три части
# Как было до разделения: все файлы в /opt/mysql.ppcmonitor
# Как должно стать после разделения: данные в /opt/mysql.ppcmonitor/data,
# бинлоги в /opt/mysql.ppcmonitor/{bin-logs,relay-logs}
# См. также задачу: https://st.yandex-team.ru/DIRECT-39169

help:
	echo "Пример использования:"
	echo "DBDIR=/opt/mysql.ppcmonitor DBINSTANCE=ppcmonitor $(MAKEFILE_LIST) <check|split-db-dir>"

check-env:
	if [ "$(DBDIR)" == "" ]; then \
		echo "Нужна переменная DBDIR с путём к каталогу с данными:"; \
		echo "export DBDIR=/opt/mysql.ppcmonitor"; \
		exit 1; \
	fi

	if [ "$(DBINSTANCE)" == "" ]; then \
		echo "Нужна переменная DBINSTANCE с названием инстанса MySQL:"; \
		echo "export DBINSTANCE=ppcmonitor"; \
		exit 1; \
	fi

check: check-env
	echo "Проверяем $(DBDIR)"
	if [ -e $(DBDIR)/data -a -e $(DBDIR)/bin-logs -a -e $(DBDIR)/relay-logs ]; then \
		echo "$(DBDIR) уже разделили на части (там есть data bin-logs relay-logs)"; \
	else \
		echo "$(DBDIR) ещё не поделили на части"; \
	fi

split-db-dir: check-env
	echo "Проверяем $(DBDIR)"
	if [ -e $(DBDIR)/data -a -e $(DBDIR)/bin-logs -a -e $(DBDIR)/relay-logs ]; then \
		echo "$(DBDIR) уже разделили на части (там есть data bin-logs relay-logs)"; \
		exit 1; \
	fi

	echo "Делим $(DBDIR) на части"

	mkdir $(DBDIR)/data

	mv $(DBDIR)/* $(DBDIR)/data ||:
	echo "(выше наверняка было сообщение про subdirectory of itself, это нормально)"

	mkdir $(DBDIR)/{bin-logs,relay-logs}
	mv $(DBDIR)/data/$(DBINSTANCE)-bin* $(DBDIR)/bin-logs
	mv $(DBDIR)/data/$(DBINSTANCE)-relay* $(DBDIR)/relay-logs

	echo "Готово."
