#!/usr/bin/perl

use my_inc '../..';

=head1 DESCRIPTION

  https://st.yandex-team.ru/DIRECT-41976

  Скрипт останавливает активные архивные баннеры. Номера групп берутся из YT, складываются в *.data файл.
  Скрипт берет актуальные данные из БД для баннеров группы и по аналогии с groups_stop останавливает баннеры группы.

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::DBShards;
use PrimitivesIds;
use Primitives;

use Settings;
use ScriptHelper;

$log->out('START');

my $filename;

extract_script_params(
    'data=s', \$filename,
);

$filename ||= "/var/www/ppc.yandex.ru/deploy/20150520_stop_archived_banners.data";
# Данные для файла были взяты из YT следующим запросом:
# yt-perl map-reduce --src db/banners --dst tmp/eboguslavskaya/3 --reduce-by pid --mapper '$S{$r->{pid}}++ if ($r->{statusShow} eq "Yes" && $r->{statusArch} eq "Yes") }{ yields \%S, pid=>"count"' --reducer 'iter {$g->{pid}=$r->{pid}}; yield $g'
# затем вохранены в файл
open( F, "<", $filename ) || $log->die($!);
my @pids = map {$_} <F>;
close F;
foreach my $pid (@pids) {
    my $bids = get_one_column_sql(PPC(pid => $pid), ["SELECT bid FROM banners", 
                                                      where=>{pid=>SHARD_IDS, statusShow=>"Yes", statusArch=>"Yes"}
                                                    ]) || [];
    next unless @$bids;

    # Вольная интерпретация Models::AdGroup::stop_group
    my $cid = get_cid(pid => $pid);
    do_update_table(PPC(bid => $bids), 'banners', 
                                    {statusShow => 'No',
                                     statusBsSynced => 'No',
                                     LastChange__dont_quote => 'NOW()',
                                     statusMetricaStop => 'No',
                                    },
                                    where => {bid => SHARD_IDS, statusShow=>"Yes", statusArch=>"Yes"});
    do_update_table(PPC(pid => $pid), 'phrases',
                       {statusAutobudgetShow => 'Yes', LastChange__dont_quote => 'LastChange'},
                        where => {pid => SHARD_IDS});
    schedule_forecast($cid);
    $log->out(sprintf("Group %d had %d wrong banners: %s",$pid, scalar(@$bids), join ",", @$bids));
}

$log->out('FINISH');
