#!/usr/bin/perl

use Direct::Modern;

use Yandex::Validate;
use Yandex::YT::Table;
use Yandex::ListUtils;
use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Retry qw/relaxed/;

use my_inc '../..';

use BS::ResyncQueue;
use ScriptHelper;
use Settings;
use Tools ();

use constant FLUSH_CHUNK_SIZE => 100_000;

my $SLEEP_COEF = 1;
$Yandex::YT::Streaming::DEFAULT_FORMAT = 'json';

my $table_path;
my $priority = BS::ResyncQueue::PRIORITY_DEFAULT;
extract_script_params(
    'table=s' => \$table_path,
    'priority=i' => \$priority,
);

unless ($table_path) {
    die "--table parameter is mandatory";
}

unless (is_valid_int($priority, -128,127)) {
    die "--priority must be in [-128,127] range";
}

my @bids;
sub flush {
    my $last = shift;
    if (@bids >= FLUSH_CHUNK_SIZE || $last) {
        for my $bids_chunk (chunks(\@bids, 5_000)) {
            relaxed times => $SLEEP_COEF, sub {
                $log->out("Got ".scalar(@$bids_chunk)." banners to stop in chunk");
                my $resync = get_all_sql(PPC(bid => $bids_chunk),
                    [ "SELECT cid, 0 as pid, bid, $priority AS priority FROM banners", where => { bid => SHARD_IDS, 'statusShow' => 'Yes' } ]);
                $log->out("Going to stop bid");
                $log->out({stopped_bids => $bids_chunk});
                my $rows_count = do_update_table(PPC(bid => $bids_chunk), 'banners',
                    { statusShow               => 'No',
                      LastChange__dont_quote   => 'NOW()',
                    },
                    where => { bid => SHARD_IDS, 'statusShow' => 'Yes' }) + 0;
                $log->out("Stopped $rows_count banners");
                bs_resync($resync);
                $log->out("Added to resync queue ".scalar(@$resync));
            };
        }
        @bids = ();
    }
}


$log->out("START");

$log->out("setup YT env");
Tools::set_yt_environment();

$log->out("Import data from $table_path with priority $priority");
my $table = Yandex::YT::Table->new($table_path);
unless ($table->exists()) {
    $log->die("table $table_path doesn't exists");
}

$log->out("let's import data");
my $reader = $table->reader(['bid']);
while(my $r = $reader->next()) {
    push @bids, $r->{bid};
    flush();
}
flush('last');

$log->out("FINISH");
