#!/usr/bin/perl

use my_inc "../..";


=head1 NAME

    test_api.pl - удобный запуск метода API с эмуляцией Plack-request

=head1 SYNOPSIS

    echo 'zhurs GetCampaignsList ["zhurs"]' | protected/one-shot/test_api.pl
    
=cut

use strict;
use warnings;

use JSON;
use Carp;
use Time::HiRes;

use Yandex::Validate;

use lib::abs '..';

use Plack::UTF8Request;

use Settings;
use ScriptHelper get_file_lock => undef, script_timer => undef;
use DoCmd;
use PrimitivesIds;
use PSGIApp::API::JSON;

use open ":std" => ":utf8";
use utf8;

extract_script_params();

my $IP = '127.0.0.1';

while(<>) {
    (my ($login, $method, $json_param) = /^([\w-]+)\s+(\w+)\s+(.+)/) || croak "Expected format: login method params_json";
    my $UID = get_uid(login => $login);
    if (!$UID && is_valid_id($login)) {
        $UID = $login;
    }

    my $req = {
        "method" => $method,
        "param" => from_json($json_param),

        "locale" =>  "en",
        "login" =>  $login,
        "application_id" =>  "eef1c9fce4874819b8399bb0bac9b9d9",
        "token" => "e4d3b4d2a7444fb387a18dda54d1c8d9"
    };

    {
        no warnings;
        *API::Authorize::authorize_user 
            = *API::authorize_user 
            = sub {return { uid => $UID, login => '', application_id => ''} };
    }

    my $uri = "/live/v4/json/";
    my $app = PSGIApp::API::JSON::get_app();

    my $json_data = to_json($req);
    open(my $req_body_fh, "<:raw", \$json_data) || die $!;
    $ENV{REMOTE_ADDR} = $IP;
    my $time_start = Time::HiRes::time;
    my $ret = $app->({
        REQUEST_METHOD => 'POST',
        REMOTE_ADDR => $IP,
        SCRIPT_NAME => $uri,
        PATH_INFO => $uri,
        REQUEST_URI => $uri,
        SERVER_NAME => 'api.direct.yandex.ru',
        SERVER_PORT => 80,
        SERVER_PROTOCOL => 'HTTP/1.0',
        CONTENT_LENGTH => length(Encode::encode_utf8($json_data)),
        CONTENT_TYPE => 'application/json; charset=utf-8',
        'psgi.input' => $req_body_fh
                     });

    printf "%.6f\n", Time::HiRes::time - $time_start;

#    print Encode::decode_utf8($ret->[2]->[0]), "\n";
}
