#!/usr/bin/perl

use my_inc "../..", for => 'api/t';


=head1 NAME

    test_api5.pl - удобный запуск метода API5 с эмуляцией Plack-request

=head1 SYNOPSIS

    echo 'zhurs campaigns.get {"SelectionCriteria":{},"FieldNames":["Id"]}' | protected/one-shot/test_api5.pl
    
=cut

use strict;
use warnings;

use JSON;
use Carp;
use Time::HiRes;

use Yandex::Validate;

use lib::abs '..';

use Plack::UTF8Request;

use Settings;
use ScriptHelper get_file_lock => undef, script_timer => undef;
use DoCmd;
use PrimitivesIds;

use API::PSGI::JSON;

use open ":std" => ":utf8";
use utf8;

extract_script_params();

my $IP = '127.0.0.1';

while(<>) {
    (my ($login, $method, $json_param) = /^([\w-]+)\s+([\w.]+)\s+(.+)/) || croak "Expected format: login method params_json";

    (my ($service, $service_method) = $method =~ /^(\w+)\.(\w+)$/) || croak "Expected method format: service.service_method";

    my $UID = get_uid(login => $login);
    if (!$UID && is_valid_id($login)) {
        $UID = $login;
    }

    my $req = {
        "method" => $service_method,
        "params" => from_json($json_param),
    };

    {
        no warnings;
        *API::Authorization::_token_auth_info = sub {
            my ($self) = @_;

            return $self->{_token_auth_info} if $self->{_token_auth_info};

            my $auth = { uid => $UID, login => $login, application_id => 'd41d8cd98f00b204e9800998ecf8427e', karma => 100500 };
            $self->operator_uid($UID);
            $self->_auth_hash_fix_operator($auth);
            $self->application_id($auth->{application_id});

            $self->{_token_auth_info} = $auth;
            return $auth;
        };

        *API::App::CheckAccess::application_has_api_access = sub($) { 1 };
    }

    my $uri = "/json/v5/$service";
    my $app = API::PSGI::JSON->get_app();

    my $json_data = to_json($req);
    open(my $req_body_fh, "<:raw", \$json_data) || die $!;
    $ENV{REMOTE_ADDR} = $IP;
    my $time_start = Time::HiRes::time;
    my $ret = $app->({
        REQUEST_METHOD => 'POST',
        REMOTE_ADDR => $IP,
        SCRIPT_NAME => $uri,
        PATH_INFO => $uri,
        REQUEST_URI => $uri,
        SERVER_NAME => 'api.direct.yandex.ru',
        SERVER_PORT => 80,
        SERVER_PROTOCOL => 'HTTP/1.0',
        CONTENT_LENGTH => length(Encode::encode_utf8($json_data)),
        CONTENT_TYPE => 'application/json; charset=utf-8',
        HTTP_ACCEPT_LANGUAGE => 'ru',
        HTTP_AUTHORIZATION => 'Bearer eef1c9fce4874819b8399bb0bac9b9d9',
        HTTP_CLIENT_LOGIN => $login,
        'psgi.input' => $req_body_fh
                     });

    printf "%.6f\n", Time::HiRes::time - $time_start;

    my @headers = @{$ret->[1]};
    while(my ($key, $val) = splice @headers, 0, 2) {
        print "$key: $val\n";
    }
    print Encode::decode_utf8($ret->[2]->[0]), "\n";
}
