#!/usr/bin/perl

=head1 DESCRIPTION

    эмуляция аццкой смеси Apache2::Request и Plack::Request для
    запуска контроллера из DoCmd без web-сервера

    например, можно использовать для дебаггинга или профилирования

    ждет на STDIN строки вида login query_string (почти как логи для load-test)
    вместо логина можно использовать UID

    gzip -cd load-test.txt.gz | grep 'cmd=\(search\|showCamps\)&' | cut -f3,4 | uniq | head

    Параметры:
        --skip N - пропустить первые N строк входного файла
        --stop - завершить работу если произошла ошибка
        --print-result - выводит Dumper от результатов
        --output-html - выводит html результата выполнения

=cut

use strict;
use warnings;
use utf8;
use Carp;

use Data::Dumper;

use Yandex::Validate;

use my_inc "../..";

use DevTools;
use PrimitivesIds;
use ScriptHelper;
$|++;

my $SKIP = 0;
my $STOP = 0;
my $PRINT_RESULT = 0;
my $OUTPUT_HTML = 0;
extract_script_params(
    "skip|s=i" => \$SKIP,
    "stop" => \$STOP,
    "print-result" => \$PRINT_RESULT,
    "output-html" => \$OUTPUT_HTML,
);

undef *Direct::ResponseHelper::error_tmpl;
undef *Direct::ResponseHelper::error;
*Direct::ResponseHelper::error_tmpl = *Direct::ResponseHelper::error = sub { 
    $_[1] = $_[4] if $_[4]; 
    die 'IGNORE' if $_[1] =~ /(Нет прав для выполнения|Доступ к интерфейсу работы с файлами табличных|отсутствуют обязательные параметры|Неправильный номер кампании или логин|Статистика по данной кампании недоступна|Доступ с вашего ip адреса|Ошибка проверки прав доступа|Нельзя редактировать архивные баннеры)/;

    die $_[1];
};

my $cnt = 0;
while (my $input = <STDIN>) {
    $cnt++;
    chomp $input;
    if ($input =~ /^(\S+)\s*(\S+)$/) {
        my ($login, $query) = ($1, $2);
        my $UID = get_uid(login => $login);
        if (!$UID && is_valid_id($login)) {
            $UID = $login;
        }
        if (!$UID) {
            croak "Can't get uid for '$login'";
        }

        my $query_log = substr($query,0,120);
        next if $cnt <= $SKIP;
        print STDERR "$cnt\t$query_log\n";
        my $last_stacktrace;
        local $SIG{__DIE__} = sub { $last_stacktrace = Carp::longmess(); };
        my $ret = eval { DevTools::process_query($UID, $query) };
        if ($@) {
            next if $@ =~ /IGNORE/;
            warn ($@ . ' ' .$last_stacktrace);
            if ($@ =~ /lost connection/i || $@ =~ /can.*t connect.*mysql/i 
                || $@ =~ /read timeout/ || $@ =~ /Server closed connection without sending/
                #|| $@ =~ /Can't connect to/
            ) {
                warn "let's try again";
                sleep 5;
                redo;
            }
            if ($@ =~ /500 Can't connect to blackbox-mimino.yandex.net/) {
                next;
            }
            exit 1 if $STOP;
        } else {
            if ($PRINT_RESULT || $OUTPUT_HTML) {
                utf8::decode($ret->[2]->[0]);

                if ($PRINT_RESULT) {
                    my $dump = Dumper($ret);
                    $dump =~ s!\\x\{([0-9a-f]+)\}!chr(hex($1))!ige;
                    print $dump;
                } elsif ($OUTPUT_HTML) {
                    print ${${$ret}[2]}[0];
                }
            }
        }

    }
}

