#!/usr/bin/perl

=head1 NAME

    unservice_orders_in_balance.pl - рассервисирование удаленных в Директе, но зависших в биллинге кампаний

=head1 DESCRIPTION

    Слегка измененная копипаста из миграции 20160118_unservice_camps_in_balance_part2.pl
    https://st.yandex-team.ru/DIRECT-47331
    https://st.yandex-team.ru/DIRECT-49846
    https://st.yandex-team.ru/DIRECT-66207
    По всем кампаниям из списка биллинга провериить наличие в PPC
        если нашли и у нее есть менеджер или агентство - пропускаем
        если нашли, но менеджера или агентства нет - удаляем в балансе менеджера и агентство
        если не нашли совсем - удаляем менеджера, агентство, меняем название и помечаем как непромодерированную

    Параметры:
    --file — расположение csv файла со списком заказов. Формат строк: "cid,ClientId,ProductID"

=cut

use my_inc '../..';

use Direct::Modern;

use Text::CSV;
use Yandex::DBTools;
use Yandex::Balance;
use Yandex::ListUtils qw/chunks/;
use Settings;
use ScriptHelper;

our $UID = 0; # operator
my $FILE;
extract_script_params(
    'file=s' => \$FILE,
);

sub main {
    if (!$FILE) {
        die("No file with csv data given.");
    }
    $log->out('START');

    my %camps;
    my $csv = Text::CSV->new ({ binary => 1 }) or $log->die("Cannot use CSV: ".Text::CSV->error_diag());
    open my $fh, "<", $FILE or $log->die("open $FILE: $!"); 

    my $i = 0;
    while (my $line = $csv->getline($fh)) {
        my ($service_order_id, $ClientID, $ProductID) = @$line;
        my ($ServiceID, $cid) = $service_order_id =~ /^(\d+)-(\d+)$/;
        $log->die({ "Failied parse CSV line" => $line }) unless $ServiceID && $cid && $ProductID && $ClientID;

        $camps{$cid} = {
            ServiceID => $ServiceID,
            ProductID => $ProductID,
            ClientID  => $ClientID,
        };
        $log->out("ServiceID =>".$ServiceID." ServiceOrderID =>".$cid." ProductID => ".$ProductID." ClientID =>".$ClientID);

    }
    close $fh;
    
    CHUNK: for my $cids_chunk (chunks([ keys %camps ], 1000)) {
        my $exists_cids = get_hash_sql(PPC(shard => "all"), [ "select cid, (ManagerUID IS NOT NULL OR AgencyUID IS NOT NULL) AS serviced from campaigns", where => {
            cid => $cids_chunk,
            statusEmpty => "No",
        }]);

        CID: for my $cid (@$cids_chunk) {
            # по одному, чтобы в логах осталась ошибка по каждому заказу
            if ($exists_cids->{$cid}) {
                $log->out("skip campaign $cid because it exists and serviced");
                next CID;
            }
            my $balance_order = {
                ServiceID      => $camps{$cid}->{ServiceID},
                ProductID      => $camps{$cid}->{ProductID},
                ServiceOrderID => $cid,
                ClientID       => $camps{$cid}->{ClientID},
                AgencyID       => 0,
                ManagerUID     => 0,
            };
            if (!exists $exists_cids->{$cid}) {
                $balance_order->{Text} = "deleted campaign";
                $balance_order->{unmoderated} = 1;
            }

            my $balance_res = balance_create_update_orders($UID, [$balance_order]);
            $log->out({ unservice_cid => $cid, balance_response => $balance_res ? "ok" : "error" });
        }
    }
    $log->out('FINISH');
}

main();
