#!/usr/bin/env perl

use my_inc "../..";

=head1 SYNOPSIS

    unservice_wallets.pl --cid=100,200,300

=head1 DESCRIPTION

    Снятие с сервисирования кампании-кошельки

=cut

use Direct::Modern;

use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use ScriptHelper;
use Campaign qw/campaign_manager_changed/;
use RBAC2::Extended;
use RBACDirect;

my @cids;
extract_script_params(
    "cid=i@"  => \@cids,
);
usage() && exit unless @cids; 

my $rbac = RBAC2::Extended->get_singleton(1) or $log->die("Can't connect to RBAC: $@");
my $campaigns = get_hashes_hash_sql(PPC(cid => \@cids), ["SELECT cid, type, ManagerUID FROM campaigns", where => {cid => SHARD_IDS}]);

for my $cid (@cids) {
    if (!$campaigns->{$cid} || $campaigns->{$cid}->{type} ne 'wallet') {
        $log->out(sprintf "campaign %d isn't a wallet", $cid);
        next;
    }
    unless (rbac_is_scampaign($rbac, $cid)) {
        $log->out(sprintf "campaign %d isn't servicing", $cid);
        next;
    }
    eval {
        my $t = Campaign::unservice_orders_in_balance([$cid]);
    };
    if ($@) {
        $log->out("unservice wallet in balance error " . $@);
        next;
    }

    my $rbac_error = rbac_move_scamp_to_nscamp($rbac, $cid);
    if ($rbac_error) {
        $log->out("rbac_move_scamp_to_nscamp(\$rbac, $cid) == $rbac_error");
        next;
    }
    $log->out(sprintf "campaign %d successfully unserviced", $cid);
    campaign_manager_changed($rbac, $campaigns->{$cid}->{ManagerUID}, $cid, 0);
    do_sql(PPC(cid => $cid), "UPDATE campaigns SET statusBsSynced = 'No' WHERE cid = ?", $cid); 
}
