#!/usr/bin/perl

=head1 DESCRIPTION

   Обновляем модели атрибуции значениями выставленными в БК.
   Данные берем из yt таблицы

=head1 USAGE

    Запуск в холостом режиме, без записи в базу
    LOG_TEE=1 ./protected/one-shot/update_attribution_model_from_yt_and_add_to_resync.pl

    Запуск с записью в базу
    LOG_TEE=1 ./protected/one-shot/update_attribution_model_from_yt_and_add_to_resync.pl --priority 85 --attribution-type 2 --table
=cut

use Direct::Modern;

use Yandex::DBShards;
use Yandex::DBTools;
use Yandex::Validate;
use Yandex::YT::Table;

use my_inc '../..';

use BS::ResyncQueue;
use ScriptHelper 'Yandex::Log' => [ date_suf => '%Y%m%d', auto_rotate => 1, tee => $ENV{LOG_TEE}, lock => 1 ];

use Settings;
use Tools ();

$Yandex::YT::Streaming::DEFAULT_FORMAT = 'json';

my $ATTRIBUTION_MODEL_VALUES = {
    1 => "last_click",
    2 => "last_significant_click",
    3 => "first_click",
};

my @FIELDS_TO_READ = qw/cid campaign_type bs_attribution_type/;

my $table_path;
my $priority = 0;
my $attribution_type;
my $dryrun;
my $chunk_size = 1000;
extract_script_params(
    'table=s'            => \$table_path,
    'priority=i'         => \$priority,
    'attribution-type=i' => \$attribution_type,
    'dry-run'            => \$dryrun,
    'chunk-size=i'       => \$chunk_size
);

unless ($table_path) {
    die "--table parameter is mandatory";
}

unless (is_valid_int($priority, -128,127)) {
    die "--priority must be in [-128,127] range";
}

my $direct_attribution_model = $ATTRIBUTION_MODEL_VALUES->{$attribution_type};
unless ($direct_attribution_model) {
    die "There are no attribution_model for attribution_type $attribution_type";
}
$direct_attribution_model = sql_quote($direct_attribution_model);
$log->out("START");
$log->out("use updating campaigns to attribution_model = $direct_attribution_model");


sub update_attribuiton_model_and_add_to_resync {
    my $cids_to_update = shift;
    $log->out("update to attribution_model=$direct_attribution_model. cids: ", $cids_to_update);
    unless ($dryrun) {
        do_sql(PPC(cid => $cids_to_update ), [ "update campaigns set attribution_model = $direct_attribution_model",
            "where" => {
                cid  => SHARD_IDS,
                attribution_model__is_null => 1} ]);


        $log->out("add data chunk to bs_resync_queue");
        my $cnt = BS::ResyncQueue::bs_resync_camps(\@$cids_to_update, priority => $priority);
        $log->out("added $cnt rows");
    }
}

sub check_update_createria {
    my $row = shift;

    if ($row->{bs_attribution_type} == $attribution_type
        && $row->{campaign_type} ne "wallet") {
        return 1;
    }
    return 0;
}

$log->out("setup YT env");
Tools::set_yt_environment();

$log->out("Import campaigns from $table_path with bs attribution_type $attribution_type");
my $table = Yandex::YT::Table->new($table_path);
unless ($table->exists()) {
    $log->die("table $table_path doesn't exists");
}

$log->out("start import data from yt");
my @cids_to_update_attribution_type;

my $reader = $table->reader(\@FIELDS_TO_READ);
while(my $campaign_bs_attribution = $reader->next()) {
    next unless check_update_createria($campaign_bs_attribution);
    $log->out($campaign_bs_attribution);

    push @cids_to_update_attribution_type, $campaign_bs_attribution->{cid};
    if (@cids_to_update_attribution_type >= $chunk_size) {
        update_attribuiton_model_and_add_to_resync(\@cids_to_update_attribution_type);
        @cids_to_update_attribution_type=();
    }

}
update_attribuiton_model_and_add_to_resync(\@cids_to_update_attribution_type);

$log->out("FINISH");
