#!/usr/bin/perl

=head1 DESCRIPTION

    Обновляет поле notifications в таблице infoblock_state - записывает всем пользователям во всех шардах.
    Новые id-шники новостей из блогов взамен старых из докцентра.
    Все новые новости считаются прочитанными и незапиненными.
    Состояние тизеров, записанных в поле notifications не меняем.

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::ListUtils qw/chunks/;
use Yandex::DateTime;
use Yandex::TimeCommon qw/mysql2unix/;

use my_inc '../..';

use PrimitivesIds;
use ScriptHelper;
use Settings;
use ShardingTools;

use JSON;


# сколько пользователей обновлять за раз
my $CHUNK_SIZE = 1_000;
# забираем новости начиная с указанной даты
my $min_date_mysql = "2018-01-01";
# все новости позже этой даты помечаются непрочитанными
my $max_read_news_date = now()->subtract(days => 1)->strftime("%Y-%m-%d");

my @logins;
extract_script_params(
    'login=s' => \@logins,
    'news-date=s' => \$max_read_news_date,
);


$log->out("START");

my $uids_only = [];
if (@logins) {
    $log->die("No logins given") unless @logins;
    $uids_only = get_uids(login => \@logins);
    $log->die("No uids found for logins") unless @$uids_only;
}

my $last_updated = now_utc->strftime("%Y-%m-%d %H:%M:%S");
my $rows = get_all_sql(PPCDICT, [
    'SELECT ext_news_id, lang, region, news_date
       FROM adv_news_items',
     WHERE => { news_date__ge => $min_date_mysql },
    'ORDER BY ext_news_id ASC']
);
$log->die("table adv_news_items is empty!") if !@$rows;

my $news_items = {};
for my $row (@$rows) {
    if (exists $news_items->{$row->{ext_news_id}}) {
        push @{$news_items->{$row->{ext_news_id}}->{langsregions}}, "$row->{lang}_$row->{region}";
    } else {
        my $status = 'read';
        if (mysql2unix($row->{news_date}) > mysql2unix($max_read_news_date)) {
            $status = 'new';
        }
        $news_items->{$row->{ext_news_id}} = {
            status => $status,
            hushed => JSON::false,
            langsregions => [ "$row->{lang}_$row->{region}"],
        }
    }
}

foreach_shard_parallel_verbose($log, sub {
    my $shard = shift;
    my $guard = $log->msg_prefix_guard("[shard $shard]");

    my %where;
    if (@$uids_only) {
        $where{WHERE} = {'uid' => $uids_only};
    }

    $log->out("get uids from infoblock_state...");
    my $uids = get_one_column_sql(PPC(shard => $shard), ["select uid from infoblock_state", %where]);
    $log->out("got ". scalar @$uids ." uids for update");

    for my $uids_chunk (chunks $uids, $CHUNK_SIZE) {
        $log->out("process uid chunk:", $uids_chunk);
        my $users_notifications = get_hash_sql(PPC(shard => $shard),
            ["select uid, notifications from infoblock_state",
            WHERE => { uid => $uids_chunk}]);
        my $to_update;
        for my $uid (keys %$users_notifications) {
            my $notification = eval { from_json($users_notifications->{$uid}) };
            if ($@) {
                $log->out("uid $uid decode_json failed, invalid json. error: $@");
            } else {
                $notification->{news} = { items => { %$news_items } };
                $to_update->{$uid}->{notifications} = to_json($notification);
            }
        }
        $log->out("updating uid chunk...");
        my $rows_updated = do_mass_update_sql(PPC(shard => $shard), 'infoblock_state', 'uid', $to_update, byfield_options => { 'last_updated' => {default => $last_updated} });
        $log->out("updated $rows_updated records in infoblock_state");
    }
});

$log->out("FINISH");
