#!/usr/bin/perl

=head1 DESCRIPTION

   Изменяем настроки сети для кампаний с автобюджетними стратегиями
   ContextPriceCoef -> 100, ContextLimit -> 0 (auto)

=head1 USAGE

    Запуск в холостом режиме, без записи в базу
    LOG_TEE=1 ./protected/one-shot/update_network_params_for_autobudget_strategies.pl --dry-run [--shard 1 ]

    Запуск с записью в базу
    LOG_TEE=1 ./protected/one-shot/update_network_params_for_autobudget_strategies.pl
=cut

use Direct::Modern;

use Try::Tiny;

use Yandex::DBShards;
use Yandex::DBTools;

use my_inc '../..', for => 'protected';
use BS::ResyncQueue;
use ScriptHelper 'Yandex::Log' => [ date_suf => '%Y%m%d', auto_rotate => 1, tee => $ENV{LOG_TEE}, lock => 1 ];
use Settings;
use ShardingTools;

my $FEATURE_NAME = "context_limit_inside_strategies";
my $DRY_RUN;
my $SHARD;
my $CAMPAIGNS_CHUNK_SIZE = 10000;

my $ONE_ITERATION = undef;
my $ONLY_CID;


extract_script_params(
    'dry-run'       => \$DRY_RUN,
    'shard:i'       => \$SHARD,
);

my $feature_percent = get_one_field_sql(PPCDICT, [
    'select json_extract(settings, "$.percent") from features',
    WHERE => { feature_text_id => $FEATURE_NAME },
    LIMIT => 1,
]);
die "Feature <$FEATURE_NAME> is not set to all clients. Stopped"  if $feature_percent != 100;
my @shards_to_process = $SHARD ? ($SHARD) : ppc_shards();

foreach_shard ( shard => [@shards_to_process], sub {
    my ($shard) = @_;

    my $msg_prefix_guard = $log->msg_prefix_guard("[shard $shard]");

    my $last_cid = 0;

    while(1) {
        my $campaigns_to_update = get_all_sql(PPC(shard => $shard), ["
            SELECT
             cid,
             ContextPriceCoef,
             ContextLimit,
             opts
            FROM
              campaigns",
            WHERE => {
                "cid__gt" => $last_cid,
                "archived" => "No",
                "autobudget" => "Yes",
                _OR => {"ContextPriceCoef__lt" => 100, ContextLimit__ne => 0}
            },
            "ORDER BY cid",
            "LIMIT $CAMPAIGNS_CHUNK_SIZE"
        ]);

        $log->out("fetched campaigns rows: " . scalar @$campaigns_to_update);
        $log->out({campaigns_info => $campaigns_to_update});

        my $cids = [map { $_->{cid}} @$campaigns_to_update];
        last unless @$cids;
        $log->out("cids to update: @$cids");

        $last_cid = $cids->[-1] + 1;

        unless($DRY_RUN) {
            do_sql(PPC(shard => $shard), [ "update campaigns с join camp_options co using (cid)
                set
                    ContextPriceCoef = 100,
                    ContextLimit = 0",
                "where" => {
                    "cid" => $cids,
                    "archived" => "No",
                    "autobudget" => "Yes",
                    _OR => {"ContextPriceCoef__lt" => 100, ContextLimit__ne => 0}
                }]) if (@$cids);

            my @resync_data = map { {
                cid => $_,
                pid => 0,
                bid => 0,
                priority => 85 } } @$cids;
            $log->out( { resync_data => \@resync_data } );

            bs_resync(\@resync_data);
        }
    }
    $log->out("finished");
});



