#!/usr/bin/perl

=head1 DESCRIPTION

    https://st.yandex-team.ru/DIRECT-104182
    Переводим оставшиеся кампании с attribution_model = NULL на 'last_yandex_direct_click' (кроме billing_aggregate)
    Сюда попадают несколько сот кампании которые сменили стратегию на конверсионную после конверсионной миграции.

=head1 USAGE

    Запуск в холостом режиме, без записи в базу
    LOG_TEE=1 ./protected/one-shot/update_null_attribution_model_to_lydc.pl --dry-run [--shard 1 ]

    Запуск с записью в базу
    LOG_TEE=1 ./protected/one-shot/update_null_attribution_model_to_lydc.pl [-- shard 1]
=cut

use Direct::Modern;

use Try::Tiny;

use Yandex::DBShards;
use Yandex::DBTools;

use my_inc '../..', for => 'protected';
use ScriptHelper;
use Settings;
use ShardingTools;

my $DRY_RUN;
my $SHARD;

extract_script_params(
    'dry-run'          => \$DRY_RUN,
    'shard:i'          => \$SHARD,
);

my $update_condition = [
    attribution_model__is_null => 1,
    type__ne  => "billing_aggregate",
];

$log->out("start");
my @shards_to_process = $SHARD ? ($SHARD) : ppc_shards();

foreach_shard ( shard => [@shards_to_process], sub {
    my ($shard) = @_;
    my $msg_prefix_guard = $log->msg_prefix_guard("[shard $shard]");

    my $campaigns_batch = get_all_sql(PPC(shard => $shard), ["
            SELECT
             cid,
             type,
             strategy_name,
             strategy_data,
             attribution_model
            FROM
              campaigns",
        WHERE => $update_condition,
    ]);

    $log->out("total campaigns with null attribution_model: " . scalar @$campaigns_batch) ;
    $log->out({campaigns_batch => $campaigns_batch});

    my @cids = map { $_->{cid}} @$campaigns_batch;
    $log->out("update cids: @cids");

    unless($DRY_RUN) {
        do_sql(PPC(shard => $shard), [ "update campaigns
                set
                   attribution_model = 'last_yandex_direct_click'",
            "where" => {
                cid => \@cids,
                @$update_condition
            }]);
    }
    $log->out("finished");
});
$log->out("all shards finished");

