#!/usr/bin/perl

use my_inc "../..";

=head1 DESCRIPTION

    Синхронизирует все существующие турболендинги клиентов с конструктором. Нужен для разовой актуализации имен турболендингов

    LOG_TEE=1 ./protected/one-shot/update_turbolanding_names.pl 

    Параметры (для тестирования):
        shard-id -- запустить только на определенном шарде
        client-id -- запустить только для определенного клиента

    Программа работает параллельно с каждым шардом. Можно перезапускать.

=cut

use Direct::Modern;
use open ':std' => ':utf8';

use Settings;
use ScriptHelper 'Yandex::Log' => 'messages';

use Yandex::DBTools;
use Yandex::DBShards;
use ShardingTools qw/ppc_shards/;
use Yandex::ListUtils qw/chunks/;
use Direct::TurboLandings;
use Try::Tiny qw/try catch/;

#На текущий момент максимальное количество клиентов с турболендингами на одном шарде - 106, поэтому CHUNK_SIZE берем небольшой
my $CHUNK_SIZE = 20;
my ($ONLY_SHARD_ID, $CLIENT_ID);
extract_script_params(
    'shard-id:i' => \$ONLY_SHARD_ID,
    'client-id:i'  => \$CLIENT_ID,
);

$log->out('START');

my $script_name = get_script_name();
my $shard_results = foreach_shard_parallel(shard => [defined $ONLY_SHARD_ID ? $ONLY_SHARD_ID : ppc_shards()], sub {
    my ($shard) = @_;

    $log->msg_prefix("shard=$shard");
    $log->out('START');
    
    try {
        my  $client_ids= get_one_column_sql(PPC(shard => $shard), ['SELECT DISTINCT ClientID FROM turbolandings', $CLIENT_ID ? (WHERE => {ClientId => $CLIENT_ID}) : ()]);

        $log->out((scalar @$client_ids)." clients found");
        my $total = 0;
        foreach my $chunk (chunks $client_ids, $CHUNK_SIZE) {
            foreach my $client_id (@$chunk){
                $log->out("Processing client $client_id");
                Direct::TurboLandings->sync_by_client_id($client_id);
                $log->out("Client $client_id synced");
                $total++;
            }
            sleep 1;
        }

        $log->out("$total clients synced");
        $log->out('FINISH');
    }
    catch {
        $log->out( join "\n", @_);
        die;
    };
});

$log->out('FINISH');
