#!/usr/bin/perl

use strict;
use warnings;
use utf8;

=head1 NAME

    wipe_user_from_shard.pl - по log-data из one-shot/reshard-user.pl удаляет все данные из указанного шарда

=head1 DESCRIPTION

    ./one-shot/wipe_user_from_shard.pl < logs/reshard.data.<сегодня> | m dt:ppc:<шард неудачного переноса>

    Скрипт предназначен для того чтобы удалить из шарда все данные клиента в
    случае неудачного решарда. По данным из шарда источника формируем лог с
    помощью запуска
        ./one-shot/reshard-user.pl --shard <любой шард> --simulate --log-data --no-validate-db-schema
    в logs/reshard.data.<СЕГОДНЯ> получаем список объектов клиента.

    После запускаем
        ./one-shot/wipe_user_from_shard.pl < logs/reshard.data.<СЕГОДНЯ> | m dt:ppc:<шард неудачного переноса>

    Скрипт опастный используйте на свой страх и риск, скрипт крайне не
    рекомендуется к использованию на продакшн средах, ЕСТЕСТВЕННО файл
    logs/reshard.data.<СЕГОДНЯ> перед получением списка данных необходимо
    почистить

=cut

use feature 'say';

use JSON;

use my_inc '../..';

use Settings;
use EnvTools;
use ScriptHelper get_file_lock => undef;
use Direct::ReShard;

die "not for production now" unless is_beta();

extract_script_params();

my %table_key = (
    campaigns => {
        key => 'cid',
        index => 0
    }
);

my $resharder = Direct::ReShard->create(
    simulate => 1,
    log_data => 0,
    validate_db_schema => 0,
    transaction_per_table => 0
);

my $tables = $resharder->tables;


my $json = JSON->new();
while(<>) {
    # 2014-10-29├─19:43:52├───[4931831:4-2:1414601032.73008]├─ROW: org_details: ["284916","266510429","309547504300018"]
    my ($table_row) = /ROW: (.+)$/ or next;
    my ($table_name, $row_json) = ($table_row =~ /^(\w+): (.+)$/) or next;
    my $table = $tables->{$table_name};

    my $row = $json->decode($row_json);
    next unless defined $table->delete_sql;
    printf($table->delete_sql . ";\n", $row->[$table->delete_key_idx]);
}


