#!/usr/bin/perl

use my_inc "..";

=encoding utf8

=head1 METADATA

<crontab>
    time: */59 */2 * * *
    package: scripts-switchman
    <switchman>
        group: scripts-other
        <leases>
            mem: 20
        </leases>
    </switchman>
</crontab>

<juggler>
    host:   checks_auto.direct.yandex.ru
    ttl:            6h
    tag: direct_group_internal_systems
</juggler>

=cut

=head1 DESCRIPTION

    ppcApiAccessSendToSandbox.pl
    Переотправляет в Песочницу доступы для зарегистрированных приложений

=cut


use strict;
use warnings;
use utf8;

use Yandex::DBTools;

use Settings;
use ScriptHelper 'Yandex::Log' => 'messages';
use SandboxClient qw/sandbox_send_app_access/;

$log->out("Start");

my $accesses = get_all_sql(PPCDICT,
    ['select application_id, access_type, manager_login, comment, check_time, min_api_version_override',
     'from api_app_access',
      where => {sync_time => '0000-00-00 00:00:00'}
    ]);

my (@ids, @fail_ids);

for my $access (@$accesses){
    if (sandbox_send_app_access($access)) {
        push @ids, $access->{application_id};
    } else {
        push @fail_ids, $access->{application_id};
    }
}
do_update_table(PPCDICT, 'api_app_access', {sync_time__dont_quote => 'NOW()'},
      where => {application_id => \@ids}
);

my $juggler_status = 'OK';
if (@ids) {
    $log->out("Sending access to Sandbox for ".join(',', @ids)." complete");
}
if (@fail_ids) {
    $log->out("Sending access to Sandbox for ".join(',', @fail_ids)." has errors");
    $juggler_status = 'WARN';
}

juggler_event(status => $juggler_status);

$log->out("Finish");

