#!/usr/bin/perl

use my_inc "..";



=head1 METADATA

<crontab>
    time: 3 3 * * *
    sharded: 1
    package: scripts-switchman
    <switchman>
        group: scripts-other
        <leases>
            mem: 150
        </leases>
    </switchman>
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    sharded:        1
    ttl:            2d4h
    tag: direct_group_internal_systems
</juggler>

<crontab>
    time: 3 3 * * *
    sharded: 1
    only_shards: 1
    package: scripts-sandbox
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    name:           scripts.ppcArchiveOldCampaigns.working.sandbox
    raw_host:       CGROUP%direct_sandbox
    raw_events:     scripts.ppcArchiveOldCampaigns.working.sandbox.shard_$shard
    vars:           shard=1
    ttl:            2d4h
    tag: direct_group_internal_systems
</juggler>

=cut

=head1 DESCRIPTION

    Архивирование устаревших кампаний

    --shard-id N
    --cid=123,234,4564 # тестирование на определенных cid
    --login=test_login # тестирование на логине

=cut

use Direct::Modern;

use Yandex::Advmon;
use Yandex::DBTools;

use Campaign::Types qw/get_camp_kind_types/;
use Common ();
use EnvTools ();
use ScriptHelper sharded => 1, 'Yandex::Log' => 'messages';
use Settings;

# Сколько дней без показов
my $DAYS_WO_SHOWS = 30;
# Сколько дней без редактирования
my $DAYS_WO_EDIT = 30;

my ($cids, $logins);
extract_script_params(
    "cid=s" => \$cids
    , "login=s" => \$logins
);
$cids = $cids ? [split(/,/, $cids)] : [];
$logins = $logins ? [split(/,/, $logins)] : [];

local $Yandex::Advmon::GRAPHITE_PREFIX = sub {[qw/direct_one_min db_configurations/, $Settings::CONFIGURATION]};

$log->out('START');
$log->out('Working only on cids:', $cids) if @$cids;
$log->out('Working only on logins:', $logins) if @$logins;

$log->out('Fetching campaigns to archive');
my @camps = @{ get_all_sql( PPC(shard => $SHARD), ["SELECT STRAIGHT_JOIN c.cid, c.uid
                                              , c.lastShowTime stat_time
                                              , c.wallet_cid
                                              , IFNULL(max(b.LastChange),0) banner_time
                                              , c.sum - c.sum_spent AS total
                                           FROM campaigns c
                                                join users u on u.uid = c.uid
                                                join phrases p on p.cid = c.cid
                                                join banners b on b.pid = p.pid
                                          WHERE ", {'c.type__not_in' => get_camp_kind_types('skip_auto_archive_campaigns')}, "
                                            AND c.sum - c.sum_spent <= 0
                                            AND c.archived = 'No'
                                            AND c.lastShowTime < subdate( now(), ? )
                                            AND c.start_time < subdate(now(), ?)
                                            AND ", {"u.login__not_in" =>  \@Settings::UNARCHIVABLE_TEST_USERS}, "
                                            AND ", {'c.AgencyID__not_in' => \@Settings::UNARCHIVABLE_AGENCYIDS}, "
                                            ", (@$cids ? (AND => {"c.cid" => $cids}) : ''), "
                                            ", (@$logins ? (AND => {"u.login" => $logins}) : ''), "
                                          GROUP by c.cid
                                         HAVING max(b.LastChange) < subdate( now(), ? )
                                                "],
                                       $DAYS_WO_SHOWS,
                                       $DAYS_WO_SHOWS,
                                       $DAYS_WO_EDIT,
                                       ) };
my $camps_cnt = scalar(@camps);
$log->out("Got $camps_cnt campaigns to archive");
monitor_values({
    flow => { ppcArchiveOldCampaigns => { camps_to_archive_count => { "shard_$SHARD" => $camps_cnt } } },
});

my $archived_camps_cnt = 0;
for my $c ( @camps ) {
    $log->out($c);

    if ($c->{wallet_cid}) {
        if ($c->{total} < 0) {
            # на кампании остался минус, пропускаем, такого быть не должно (баланс должен компенсировать минусы)
            $log->out("debt on campaign(cid: $c->{cid}) in wallet for wallet_cid: $c->{wallet_cid}, skip");
            next;
        }

        $log->out('Checking if it is the last campaign connected to wallet');
        my $is_not_last_camp = get_one_field_sql(PPC(shard => $SHARD), ["
            select 1
            from campaigns c
         ", where => {
                'c.uid' => $c->{uid},
                'c.wallet_cid' => $c->{wallet_cid},
                'c.type' => Campaign::Types::get_camp_kind_types('under_wallet'),
                'c.archived' => 'No',
                'c.statusEmpty' => 'No',
                'c.cid__ne' => $c->{cid},
            }, "
            limit 1
        "]);

        if (!$is_not_last_camp) {
            # если кампания в общем счете осталась одна, не архивируем её
            $log->out("last campaign ($c->{cid}) in wallet for wallet_cid: $c->{wallet_cid}, skip");
            next;
        }
    }

    my ($arc_result, $arc_error) = Common::_arc_camp($c->{uid}, $c->{cid}, archive_non_stopped => 1, force => 1);
    $log->out({cid => $c->{cid}, arc_result => $arc_result, arc_error => $arc_error});

    if ($arc_result) {
        $archived_camps_cnt++;
    }
}
$log->out("All campaigns has been archived.");

monitor_values({
    flow => { ppcArchiveOldCampaigns => { camps_archived_count => { "shard_$SHARD" => $archived_camps_cnt } } },
});

juggler_ok(service_suffix => (EnvTools::is_sandbox() ? 'sandbox' : undef));

$log->out('FINISH');
