#!/usr/bin/perl

use my_inc "..";



=head1 METADATA

# ppcAutobanUsers.pl: avg: 56 MB, max: 85 MB
<crontab>
    time: */59 * * * *
    <switchman>
        group: scripts-other
        <leases>
            mem: 80
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    ttl:          4h
    tag: direct_group_internal_systems
</juggler>

=cut

# $Id$

=head1 NAME

    ppcAutobanUsers.pl
    
=head1 DESCRIPTION

    Автобан пользователей за превышение числа фраз, ставим каптчу, 
    если пользователь не был благословлен вручную
    бан ставим сразу на всех представителей (по ClientID)

    Опции командной строки:
    --help - справка
    --upper-bound=XXX - количество объектов, начиная с которого думаем о бане
    --money-coef=XXX - сколько фраз за 1у.е. зачисленных денег мы разрешаем дополнительно

=head1 INTERNALS

=cut

use strict;
use warnings;

use List::MoreUtils qw/uniq/;

use ScriptHelper 'get_file_lock' => ['dont_die'], 'Yandex::Log' => 'messages';

use Client;
use PrimitivesIds;
use Settings;
use Tools;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::HashUtils;

my $UPPER_BOUND = $Settings::AUTOBAN_UPPER_BOUND;
my $MONEY_COEF  = $Settings::AUTOBAN_MONEY_COEF;

extract_script_params(
    'upper-bound=i' => \$UPPER_BOUND,
    'money-coef=i' => \$MONEY_COEF,
);

my $active_clients = get_active_clients();
my $banned_clients = get_banned_clients();

my $ClientIDs_to_check = [@$active_clients, @$banned_clients];

my $client_total_sums = mass_client_total_sums(ClientIDs => $ClientIDs_to_check, type => 'text', currency => 'YND_FIXED');
my $clientid2sums = hash_map {$_->{sum}} $client_total_sums;
my %client_sums = %$clientid2sums;

my %client_bids = map { $_->{ClientID} => $_->{bids} }
 @{ get_all_sql(PPC(ClientID => $ClientIDs_to_check), [
    'SELECT u.ClientID, count(bi.id) AS bids
    FROM users u
    JOIN campaigns c USING(uid)
    JOIN bids bi USING(cid)',
    WHERE => {'u.ClientID' => SHARD_IDS},
    'GROUP BY u.ClientID'
    ])
  };

my %bonus = map { $_->{ClientID} => $_->{autoban_bonus} }
 @{ get_all_sql(PPC(ClientID => $ClientIDs_to_check), [
    'SELECT ClientID, autoban_bonus
    FROM clients_autoban',
    WHERE => {ClientID => SHARD_IDS}
    ])
 };

my @bad_clients = grep { $client_bids{$_} > $UPPER_BOUND + $MONEY_COEF * ($client_sums{$_}||0) + ($bonus{$_}||0) } keys %client_bids;
my %bad_clients = map {$_ => 1} @bad_clients;
my @clients_to_unban = grep {! $bad_clients{$_}} @$banned_clients;

foreach my $ClientID (@clients_to_unban) {
    do_sql(PPC(ClientID => $ClientID), "
        UPDATE clients_autoban
        SET is_autobanned = 'No', autoban_date = now()
          , bids_count = 0, sum_total = 0
        WHERE ClientID = ?
        ", $ClientID);
    $log->out("Unbanned user ClientID: $ClientID");
}

foreach my $ClientID (@bad_clients) {
    do_sql(PPC(ClientID => $ClientID), "
        INSERT INTO clients_autoban(ClientID, autoban_date, is_autobanned, bids_count, sum_total)
        VALUES(?, now(), 'Yes', ?, ?)
        ON DUPLICATE KEY UPDATE
            autoban_date = now()
            , is_autobanned = 'Yes'
            , bids_count = values(bids_count)
            , sum_total = values(sum_total)
        ", $ClientID, $client_bids{$ClientID}, $client_sums{$ClientID});
    $log->out("Banned user ClientID: $ClientID bids: $client_bids{$ClientID}, sum: $client_sums{$ClientID}");
}

juggler_ok();

#-----------------------------------------------------------

=head2 get_active_clients

    Выбираем из логов пользователей, которые пользовались интерфейсом последний час (ClientID)

=cut

sub get_active_clients {
    my $look_back_seconds = 60*60;

    my $web_uids = _ch_get_one_column(uid => "SELECT DISTINCT uid
        FROM ppclog_cmd
        WHERE log_time > (now() - $look_back_seconds)
            AND cmd NOT LIKE 'ajax%'
            AND cmd NOT LIKE 'show%'
        FORMAT JSON
        ");

    my $api_uids = _ch_get_one_column(uid => "SELECT DISTINCT uid
        FROM ppclog_api
        WHERE log_time > (now() - $look_back_seconds)
            AND cmd in ('keywords.add', 'ads.add', 'adgroups.add', 'campaigns.add')
        FORMAT JSON
        ");

    return [] unless (@$web_uids || @$api_uids);

    my @all_uids = uniq @$web_uids, @$api_uids;
    my $clients = get_clientids(uid => \@all_uids);
    return $clients;
}

sub _ch_get_one_column {
    my ($column, $sql) = @_;
    my $values = [];
    my $clh = get_clickhouse_handler('cloud');
    my $result = $clh->query($sql);
    for my $row ( @{ $result->json->{data} } ) {
        push @$values, $row->{$column};
    }
    return $values;
}

#-----------------------------------------------------------

=head2 get_banned_clients

    Возвращаем забаненных пользователей (ClientID)

=cut

sub get_banned_clients
{
    return get_one_column_sql(PPC(shard => 'all'), "
        SELECT ClientID
        FROM clients_autoban
        WHERE is_autobanned = 'Yes'
        ") || [];
}
