#!/usr/bin/perl

use my_inc "..";

=head1 METADATA

<crontab>
    time: */5 * * * *
    <switchman>
        group: scripts-other
    </switchman>
    package: scripts-switchman
</crontab>

<juggler>
    host:   checks_auto.direct.yandex.ru
    ttl:        30m
</juggler>


=cut

=head1 DESCRIPTION

Скрипт переотправляет в Баланс клиентов ограниченных представителей

=cut

use Direct::Modern;

use Yandex::DBQueue;
use Yandex::DBShards;
use Yandex::DBTools;
use Yandex::Retry qw/relaxed_guard/;
use Yandex::I18n;

use Yandex::ListUtils qw/chunks/;
use Yandex::HashUtils qw/hash_merge/;
use List::MoreUtils qw/uniq/;
use Agency qw//;

use Settings;
use ScriptHelper;
use ShardingTools qw/ppc_shards/;


my $TRYCOUNT = 5;
my $SLEEP_COEF = 1;
my $MAX_ITERATIONS = 1;
my $UIDS_CHUNK_SIZE = 100;
my $CLIENT_IDS_CHUNK_SIZE = 20;

$log->out("START");

$Yandex::DBQueue::LOG = $log;
my $queue = Yandex::DBQueue->new(PPCDICT, 'balance_resync_limited_rep');

foreach my $iteration (1 .. $MAX_ITERATIONS) {

    if (my $job = $queue->grab_job()) {

        if ($job->trycount > $TRYCOUNT) {
            $job->mark_failed_permanently({ error => 'Unknown error' });
            next;
        }

        my $resync_all_clients = $job->args->{resync_all_clients} ? 1 : 0;
        my @client_ids = $resync_all_clients ? () : @{ $job->args->{client_ids} // [] };
        my $force_reset = $job->args->{force_reset} ? 1 : 0;

        unless ($resync_all_clients || @client_ids) {
            $job->mark_failed_permanently({ error => 'Clients not found' });
            $log->out('Clients not found');
            next;
        }
 
        eval {
            process_job($resync_all_clients, $force_reset, @client_ids);
        };
        if ($@) {
            $log->out("job failed once: $@");
            $job->mark_failed_once();
        } else {
            $job->mark_finished({});
        }
    }
}

sub process_job {
    my ($resync_all_clients, $force_reset, @client_ids) = @_;

    for my $shard (ppc_shards()) {
        $log->out('');
        $log->msg_prefix("[shard_$shard]");

        # находим ограниченных представителей агенств
        # достаем все записи одним запросом (на 1м шарде их < 14_000, на остальных меньше)
        my $agency_limited_reps = get_all_sql(PPC(shard => $shard), [ 
            "SELECT u.uid, u.rep_type, c.ClientID, c.role 
             FROM users u INNER JOIN clients c ON c.ClientID = u.ClientID",
             WHERE => { 'c.role' => 'agency', 
                        'u.rep_type' => 'limited',
                        (@client_ids ? ('c.ClientID' => \@client_ids) : ()) },
            'ORDER BY' => 'c.ClientID, u.uid',
        ]);

        my @limited_rep_uids = map { $_->{uid} } @$agency_limited_reps;
        $log->out("limited_rep_uids count: " . scalar(@limited_rep_uids));
        next unless @limited_rep_uids;

        # разбиваем на чанки по 100 uid, (1 запрос в баланс на 1 uid) 
        # между отправкой чанков должен спать (чтобы не отправить сразу слишком много запросов)
        my $success_by_uid = {};
        for my $uids_chunk (chunks(\@limited_rep_uids, $UIDS_CHUNK_SIZE)) {
            my $rg = relaxed_guard times => $SLEEP_COEF;
            $log->out("uids_chunk: " . join(', ', @$uids_chunk));

            # отправляем в баланс
            my $result = eval { Agency::refresh_clients_of_agency_limited_reps($uids_chunk, undef, $log, $force_reset) };
            $log->out("Got error: " . $@) if $@;
            hash_merge($success_by_uid, $result);
        }

        my @failed_client_ids = uniq map { $_->{ClientID} } grep { !$success_by_uid->{ $_->{uid} } } @$agency_limited_reps;

        if (@failed_client_ids) {
            $log->out("failed_client_ids: " . join(', ', @failed_client_ids));
            $log->out("failed rep uids: " . join(', ', grep { !$success_by_uid->{$_} } keys %$success_by_uid));
            die 'fail to resync clients' unless $resync_all_clients;

            for my $client_ids_chunk (chunks(\@failed_client_ids, $CLIENT_IDS_CHUNK_SIZE)) {
                my $job = Yandex::DBQueue->new(PPCDICT, 'balance_resync_limited_rep')->insert_job({
                        job_id => get_new_id('job_id'),
                        ClientID => 0,
                        args => {client_ids => $client_ids_chunk},
                });
                $log->out("New job added into DBQueue: " . $job->job_id . " client_ids: " . join(', ', @$client_ids_chunk));
            }
        }
        $log->msg_prefix("");
    }
}


$queue->delete_old_jobs(24 * 60 * 60);

juggler_ok();

$log->out("FINISH");
