#!/usr/bin/perl

use my_inc "..";



=head1 METADATA

<crontab>
    params: --par-id=easy:1
    sharded: 1
    flock: 1
    time: */10 * * * *
    <switchman>
        group: scripts-test
    </switchman>
    package: conf-test-scripts
</crontab>
<crontab>
    params: --par-id=easy:2
    sharded: 1
    flock: 1
    time: */10 * * * *
    <switchman>
        group: scripts-test
    </switchman>
    package: conf-test-scripts
</crontab>
<crontab>
    ulimit: -s 65536
    params: --par-id=heavy:1
    sharded: 1
    flock: 1
    time: */10 * * * *
    <switchman>
        group: scripts-test
    </switchman>
    package: conf-test-scripts
</crontab>
<crontab>
    ulimit: -s 65536
    params: --par-id=hard:1
    sharded: 1
    flock: 1
    time: */10 * * * *
    <switchman>
        group: scripts-test
    </switchman>
    package: conf-test-scripts
</crontab>

# PRODTUCION
# ВАЖНО! при изменении состава/количества потоков - отредактируй juggler-проверку ниже.
<crontab>
    params: --par-id=easy:1
    sharded: 1
    time: */5 * * * *
    <switchman>
        group:      scripts-other
        <leases>
            mem:   500
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    params: --par-id=easy:2
    sharded: 1
    time: */5 * * * *
        <switchman>
        group:      scripts-other
        <leases>
            mem:   500
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    params: --par-id=abuse:1
    sharded: 1
    time: */5 * * * *
        <switchman>
        group:      scripts-other
        <leases>
            mem:   600
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -s 65536
    params: --par-id=heavy:1
    sharded: 1
    time: */5 * * * *
        <switchman>
        group:      scripts-other
        <leases>
            mem:   1024
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    ulimit: -s 65536
    params: --par-id=hard:1
    sharded: 1
    time: */5 * * * *
        <switchman>
        group:      scripts-other
        <leases>
            mem:   1024
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>

<juggler>
    raw_events: scripts.ppcCampAutoPrice.working.$queue.shard_$shard
    host:       checks_day.direct.yandex.ru
    sharded:    1
    vars:       queue<ttl=45m>=easy1,easy2
    vars:       queue<ttl=3h>=heavy1,abuse1
    vars:       queue<ttl=4h>=hard1
    tag: direct_group_internal_systems
    <notification>
        template: on_status_change
        status: OK
        status: CRIT
        method: telegram
        login: DISMonitoring
    </notification>
</juggler>


<monrun>
    name:           direct.camp_auto_price.easy.max_age_day
    juggler_host:   checks_day.direct.yandex.ru
    warn: 3600
    crit: 9000
    span: 1d
    vars: n=1,2
    sharded: 1
    expression: 'diffSeriesTime(keepLastValue(direct_one_min.db_configurations.production.flow.camp_auto_price.easy$n.max_age.shard_$shard))'
    timeout: 80
    tag: direct_group_internal_systems
    tag: direct_queues
</monrun>
<monrun>
 juggler_host:   checks_auto.direct.yandex.ru
    name:           direct.camp_auto_price.easy.max_age
    warn: 7200
    crit: 14400
    span: 1d
    vars: n=1,2
    sharded: 1
    expression: 'diffSeriesTime(keepLastValue(direct_one_min.db_configurations.production.flow.camp_auto_price.easy$n.max_age.shard_$shard))'
    timeout: 30
    tag: direct_group_internal_systems
    tag: direct_queues
</monrun>

<monrun>
 juggler_host:   checks_auto.direct.yandex.ru
    name: direct.camp_auto_price.heavy.max_age
    warn: 14400
    crit: 30000
    span: 1d
    sharded: 1
    vars: n=1
    expression: 'diffSeriesTime(keepLastValue(direct_one_min.db_configurations.production.flow.camp_auto_price.heavy$n.max_age.shard_$shard))'
    timeout: 30
    tag: direct_group_internal_systems
    tag: direct_queues
</monrun>

<monrun>
 juggler_host:   checks_auto.direct.yandex.ru
    name: direct.camp_auto_price.abuse.max_age
    warn: 28800
    span: 1d
    sharded: 1
    expression: 'diffSeriesTime(keepLastValue(direct_one_min.db_configurations.production.flow.camp_auto_price.abuse1.max_age.shard_$shard))'
    timeout: 30
    tag: direct_group_internal_systems
    tag: direct_queues
</monrun>
<monrun>
 juggler_host:   checks_auto.direct.yandex.ru
    name: direct.camp_auto_price.hard.max_age
    warn: 28800
    span: 1d
    sharded: 1
    expression: 'diffSeriesTime(keepLastValue(direct_one_min.db_configurations.production.flow.camp_auto_price.hard1.max_age.shard_$shard))'
    timeout: 30
    tag: direct_group_internal_systems
    tag: direct_queues
</monrun>


=cut

# $Id$

=head1 NAME

    ppcCampAutoPrice.pl

=head1 DESCRIPTION

    Оффлайновая простановка цен на кампаниях
    https://jira.yandex-team.ru/browse/DIRECT-4966

    Возможные параметры:
        --once - отработать одну итерацию и выйти
        
        --par-id=<easy|heavy|abuse|hard>:1 - тип очереди и номер очереди (распределяется по id заказов на пересчет)

            easy - основная очередь, уменьшенный таймаут на отработку заданий

            heavy - запуск скрипта по "тяжёлым" кампаниям. Тяжёлая - это такая кампания,
               у которой кол-во фраз на всех баннерах, исключая архивные >= $NUMBER_OF_PHRASES_IN_HEAVY_CAMP.
               Либо задание на обработку которой явным убразом помещено в очередь heavy.
               Значение $NUMBER_OF_PHRASES_IN_HEAVY_CAMP можно посмотреть внутри этого скрипта.
               ВАЖНО: если при запуске скрипта предаётся аргумент --cid, то --heavy не учитывается,
               т.е. обрабатываться будут все кампании заданные в --cid.

            abuse - отдельная очередь для отработки заданий созданных операторами из списка $ABUSE_OPERATOR_UIDS

            hard - очередь с увеличенным таймаутом для отработки тяжелых заданий.
            Если отработка задания из очереди easy|heavy|abuse завершилась по таймауту - задание переводится в очередь hard

        --cid <cid>
            обрабатывать только указанные кампании. 
            Можно использовать несколько раз: ppcCampAutoPrice.pl --cid 111 --cid 112 --cid 113
            Можно перечислять несколько номеров через запятую: ppcCampAutoPrice.pl --cid 111,112,113
            Можно вперемежку: ppcCampAutoPrice.pl --cid 111,112 --cid 113
            ВАЖНО: если задан этот параметр, то параметр --heavy не учитывается,
            т.е. обрабатываться будут все кампании заданные в --cid.

            Для отладки удобно использовать вмесе с --once: 
            ppcCampAutoPrice.pl --once --cid 173

        --timeout <secs>
            задать таимаут в секундах на обработку одной кампании. Опционально, по-умолчанию 900 секунд

=cut

use Direct::Modern;

use ScriptHelper get_file_lock => undef
               , script_timer => undef
               , sharded => 1
               , 'Yandex::Log' => 'messages';

use List::MoreUtils qw/none/;

use Settings;
use Yandex::DBTools;
use Yandex::Compress;
use Yandex::HashUtils qw/hash_merge hash_cut/;
use Yandex::Advmon;
use Yandex::Log;
use Yandex::Trace;

use LockTools;
use Campaign qw//;
use CampAutoPrice::Common;
use CampAutoPrice::Process;
use DirectContext;
use Tools ();
use MailNotification;
use Notification;
use PlacePrice;
use JSON;

=head1 SUBROUTINES/METHODS/VARIABLES

=cut

our $ROW_PROCESSING_TIMEOUT = 900;  #дефолтное количество секунд на обработку одного таска
our $MAX_CYCLES_ON_EXEC = 1000;   # макс. количество итераций на один запуск скрипта
our $CYCLE_TIME_LIMIT = 5 * 60; # макс. время обработки одной итерации, секунд (для более равномерной отправки данных в мониторинг)
our $SLEEP_BETWEEN_EXEC = $Settings::CampAutoPrice_SLEEP_BETWEEN_EXEC // 60;    # пауза между итерациями, секунд
our $NUMBER_OF_PHRASES_IN_HEAVY_CAMP = 6000; # при превышении заданного количества фраз в кампании - отправляем в тяжелую очередь
our $NUMBER_OF_TRIES = 3;        # макс. количество попыток на каждое задание
our $ROW_PROCESSING_TIMEOUTS_BY_QUEUE_TYPE = { # количество секунд на обработку одного таска в зависимости от типа очереди
    easy => 600,
    hard => 3000,
};

# Обрабатываем запросы от операторов в отдельной очереди
our $ABUSE_OPERATOR_UIDS = [
    # Ashmanov1919, ostrovok-ad, marilyn-b4e, marilyn-b4e-megafon [Блондинка], marilyn-b4e-reserve
    14920123, 128725648, 254098119, 349601451, 317168218,
    # a-center-0*
    314244217, 314248453, 314248229, 314248805, 314248951,
    # drxdion
    90678641,
    # shush4ewitch
    379524768,
];

our $MAX_TASKS_FOR_CYCLE = 100;  # максимальное количество заданий на одну итерацию

#типы очередей, и количество потоков которое их должно(!) обрабатывать
# NB: не забудь поправить juggler-проверку!
our %QUEUES = (easy  => 2,
               heavy => 1,
               hard  => 1,
               abuse => 1);

local $Yandex::Advmon::GRAPHITE_PREFIX = sub {[qw/direct_one_min db_configurations/, $Settings::CONFIGURATION]};

#-----------------------------------------------------------
sub main
{
    my ($ONCE, @cids, $par_id);
    extract_script_params(
        'par-id=s' => \$par_id,
        'once' => \$ONCE,
        'cid=s@' => \@cids,
        'timeout=i' => \$ROW_PROCESSING_TIMEOUT,
    );

    @cids = split(/,/, join(',', @cids));
    my ($queue_type, $queue_order) = split qr/:/, ($par_id || ''); 
    if (@cids) {
        die "unknown queue: $queue_type" if defined $queue_type && !$QUEUES{$queue_type};
        $queue_type //= '';
        undef $queue_order;
    }
    else {
        die "incorrect par-id" unless ($queue_type && $QUEUES{$queue_type} && $queue_order > 0 && $queue_order <= $QUEUES{$queue_type});
    }

    my $type = $queue_type ? join('', $queue_type, $queue_order // 1) : 'easy';
    my $SCRIPT = get_script_name();

    my $lock_filename = "ppcCampAutoPrice_$type" . "_$SHARD";
    get_file_lock('dont_die', $lock_filename);

    $log->msg_prefix("[$type,shard_$SHARD]");

    $log->out('START');

    my $camp_condition = {
        status => 'Wait',
        (@cids ? (cid => \@cids) : ())
    };

    my @camp_condition_plain_sql;
    unless (@cids) {
        my $queue_specifed_conditions = { operator_uid__not_in => $ABUSE_OPERATOR_UIDS };
        if($queue_type eq 'heavy'){
            $queue_specifed_conditions->{number_of_phrases__ge} = $NUMBER_OF_PHRASES_IN_HEAVY_CAMP;
        } elsif($queue_type eq 'abuse'){
            $queue_specifed_conditions->{operator_uid} = delete $queue_specifed_conditions->{operator_uid__not_in};
        }
        elsif ($queue_type eq 'hard') {
            # нет дополнительных условий, только явное задание очереди
            $camp_condition->{queue_type} = $queue_type;
        }
        else {
            # $queue_type eq 'easy'
            $queue_specifed_conditions->{number_of_phrases__lt} = $NUMBER_OF_PHRASES_IN_HEAVY_CAMP;
        }
        #Если у задания очередь задана явно - используем ее, иначе определяем по атрибутам задания
        unless (exists $camp_condition->{queue_type}){
            $camp_condition->{_OR} = {queue_type => $queue_type, _AND => { queue_type__is_null => 1, %$queue_specifed_conditions }};
        }

        push @camp_condition_plain_sql, "and MOD(cid,$QUEUES{$queue_type}) = " . ($queue_order - 1) if defined $queue_order;
    }

    if (!@cids) {
        my $queue_size = get_one_column_sql(PPC(shard => $SHARD), ["SELECT COUNT(*) FROM auto_price_camp_queue", WHERE => $camp_condition]);
        local $Yandex::Advmon::GRAPHITE_PREFIX = sub {[qw/direct_one_min db_configurations/, $Settings::CONFIGURATION]};
        monitor_values({
            "flow.camp_auto_price.$type.queue_size.shard_$SHARD" => $queue_size,
        });
	$log->out("sending to graphite: type $type, shard $SHARD, queue size $queue_size");
    }

    for my $cycle_num (1 .. $MAX_CYCLES_ON_EXEC) {
        check_for_stop();
        my $trace = Yandex::Trace->new(service => 'direct.script', method => 'ppcCampAutoPrice', tags => "$type,shard_$SHARD");

        $log->out("another one iteration: #$cycle_num");
        my ($iter_start_time, $ela) = (time(), 0);

        my $queue = get_all_sql(PPC(shard => $SHARD), ["
                                      select id, cid, operator_uid
                                           , params_hash
                                           , params_compressed
                                           , tries
                                           , number_of_phrases
                                           , UNIX_TIMESTAMP(add_time) as add_unix_time
                                      from auto_price_camp_queue",
                                      where => $camp_condition,
                                      @camp_condition_plain_sql,
                                      "order by id asc
                                       limit ?
                                     "], $MAX_TASKS_FOR_CYCLE) || [];
        $log->out("to process: " . (scalar @$queue) . " items". (@cids ? " (restricted by --cid)" : ""));

        if (!@cids) {
            my $min_add_time = ($queue && @$queue > 0) ? $queue->[0]->{add_unix_time} : time();
            monitor_values({
                "flow.camp_auto_price.$type.max_age.shard_$SHARD" => $min_add_time,
            });
            $log->out("sending to graphite: type $type, shard $SHARD, min add time $min_add_time");
        }

        my $timeouts_num = 0;
        my $invalid_prices_cnt = 0;
        my $ALREADY_PROCESSED = {};
        my %success_stat = (ok => 0, error => 0);
        for my $row (@$queue) {
            check_for_stop();

            next if $ALREADY_PROCESSED->{ $row->{cid} . '_' . $row->{params_hash} }++;

            my $res = eval { process_row($row, $queue_type) };
            if($@){
                $log->out("error: $@");
                $success_stat{error}++;
            } else {
                $invalid_prices_cnt += $res->{invalid_prices_cnt};
                juggler_ok(service_suffix => $type, description => "processed task id $row->{id}");
                if ($res->{timed_out}) {
                    $success_stat{error}++;
                    $timeouts_num++;
                } else {
                    $success_stat{ok}++;
                }
            }

            $ela = time() - $iter_start_time;
            if ($ela > $CYCLE_TIME_LIMIT) {
                $log->out("iteration stopped by time limit");
                last;
            }
        }

        if (!@cids) {
            monitor_values({
                "flow.camp_auto_price.$type.timeouts_num.shard_$SHARD" => $timeouts_num,
                "flow.camp_auto_price.$type.invalid_prices.shard_$SHARD" => $invalid_prices_cnt,
                "flow.camp_auto_price.$type.errors_count.shard_$SHARD" => $success_stat{error},
                "flow.camp_auto_price.$type.successes_count.shard_$SHARD" => $success_stat{ok},
            });
        }
        juggler_ok(service_suffix => $type, description => 'iteration done');
        $log->out("iteration done");
        last if $ONCE;
        if ($cycle_num != $MAX_CYCLES_ON_EXEC && $ela < $SLEEP_BETWEEN_EXEC && @$queue < $MAX_TASKS_FOR_CYCLE) {
            my $profile = Yandex::Trace::new_profile('sleep');
            my $sleep_duration = $SLEEP_BETWEEN_EXEC - $ela;
            $log->out("sleep for $sleep_duration seconds");
            sleep($sleep_duration);
        }
        
        $trace = undef;
    }

    $log->out('FINISH');

    release_file_lock();
}

=head2 process_row

    process($row, $queue_type);

    Возвращает хеш со статусами завершения задачи:
        - success - успешно или нет завершилась обработка;
        - timed_out - затаимаутилась или нет задача (может быть истиной только когда success ложно).

=cut

sub process_row
{
    my ($row, $queue_type) = @_;

    my $params_json = Yandex::Compress::mysql_uncompress($row->{params_compressed});
    $log->out("start proccessing: $row->{id} $row->{cid} $row->{number_of_phrases} $params_json");
    my $start_time = time();

    # update делаем именно здесь, потому что скрипт может вылетать (что уже случалось) до update-а который выполняется в конце итерации
    if ($row->{tries} < $NUMBER_OF_TRIES ) {
        do_update_table(PPC(shard => $SHARD), 'auto_price_camp_queue', { tries__dont_quote => 'tries + 1' }, where => { id => $row->{id} });
    } else {
        do_update_table(PPC(shard => $SHARD), 'auto_price_camp_queue', { status => 'Error',
                                                        send_time__dont_quote => 'NOW()',
                                                        error_str => 'Number of tries exceeded' }, 
                                                      where => { id => $row->{id} });
        return;
    }

    # for log price changes and save notifications
    Tools::_save_vars($row->{operator_uid});
    MailNotification::save_UID_host($row->{operator_uid});
    local $DirectContext::current_context = DirectContext->new({UID=>$row->{operator_uid}});
    my $params = from_json($params_json);

    _correct_params_from_db_inplace($params);

    my $options = hash_merge {dont_clear_auto_price_queue => 1},
        (hash_cut($params, qw/api ignore_no_active phrase_ids/));
    delete $params->{$_} foreach(qw/api ignore_no_active phrase_ids/);
    $options->{log} = $log;
    my $invalid_prices_cnt = 0;
    $options->{out_invalid_prices_cnt} = \$invalid_prices_cnt;

    my ($result, $timed_out);
    eval {
        local $SIG{ALRM} = sub {
            $timed_out = 1;
            die $Settings::TIMEOUT_ALERT_MESSAGE;
        };
        alarm($ROW_PROCESSING_TIMEOUTS_BY_QUEUE_TYPE->{$queue_type} // $ROW_PROCESSING_TIMEOUT);
        $result = set_camp_auto_price($row->{cid}, $params, $options);
        alarm(0);
    };
    if ($@) {
        die $@ unless $timed_out;
        $result = 'set_camp_auto_price_timeout';
        $log->out("timed out: task_id=$row->{id}, cid=$row->{cid}");
    }
    my $status = 'Send';
    my %change_queue;
    my $queue = $queue_type || $row->{queue_type} || 'easy';
    if ( $timed_out && $queue ne 'hard' ){
        %change_queue = (queue_type => 'hard');
        $status = 'Wait';
    }
    elsif($result){
        $status = 'Error';
        _send_notification($row->{cid}, $row->{operator_uid}) if $timed_out;
    }
    my $updated_rows = do_update_table(PPC(shard => $SHARD), 'auto_price_camp_queue'
                       , {status => $status, %change_queue, ( $status ne 'Wait' ? (send_time => 'NOW()') : () ), error_str => $result}
                       , where => {cid => $row->{cid}, status => 'Wait', params_hash => $row->{params_hash}}
                       , dont_quote => ['send_time']
                   );

    my $seconds_in_queue = time() - $row->{add_unix_time};
    my $seconds_process = time() - $start_time;
    $log->out( sprintf "proccess: $row->{id} $row->{cid} - \%s. updated $updated_rows rows for $seconds_process seconds (%s phrases)(time in queue $seconds_in_queue)",
        $result || 'ok', $row->{number_of_phrases});

    return {timed_out => $timed_out, success => ($result ? 0 : 1), invalid_prices_cnt => $invalid_prices_cnt};
}


sub _correct_params_from_db_inplace {
    my ($params) = @_;

    $params->{change_all_banners} = 1 unless (defined $params->{change_all_banners} && $params->{change_all_banners} == 0);

    if (!$params->{use_position_ctr_correction} && $params->{price_base} && none { $_ eq $params->{price_base} } @PlacePrice::ALL_PLACES_ORDERED) {
        $params->{price_base} = CampAutoPrice::Common::convert_base_place_from_templates($params->{price_base});
    }
    if ($params->{on_search} && !$params->{on_search}{use_position_ctr_correction} && $params->{on_search}{price_base} &&
        none { $_ eq $params->{on_search}{price_base} } @PlacePrice::ALL_PLACES_ORDERED
    ) {
        $params->{on_search}{price_base} = CampAutoPrice::Common::convert_base_place_from_templates($params->{on_search}{price_base});
    }
}

=head2 check_for_stop

    Проверить, нужно ли продолжать работу. Если нет - залогировать и выйти.

=cut
sub check_for_stop {
    if (my $reason = smart_check_stop_file()) {
        $log->out("$reason! Exiting.");
        exit 0;
    }
}

sub _send_notification {
    my ($cid, $uid) = @_;
    my $camp_info = Campaign::get_camp_info($cid);
    Notification::add_notification(undef, 'auto_price_camp_queue_task_failed', {cid => $cid, uid => $uid}, {camp_info => $camp_info});
}

#-----------------------------------------------------------
main();
