#!/usr/bin/perl

use my_inc "..";


=head1 METADATA

<crontab>
    time: */3 * * * *
    sharded: 1
    <switchman>
        group: scripts-other
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    time: */10 * * * *
    sharded: 1
    <switchman>
        group: scripts-test
    </switchman>
    package: conf-test-scripts
</crontab>

<juggler>
    host:   checks_auto.direct.yandex.ru
    sharded: 1
    ttl:     1800
    tag: direct_group_internal_systems
</juggler>

<monrun>
 juggler_host:   checks_auto.direct.yandex.ru
    name: CampCopyReportsQueue.new_reports
    warn: 3
    crit: 6
    expression: 'keepLastValue(direct_one_min.db_configurations.production.flow.CampCopyReportsQueue.new_reports.shard_$shard)'
    sharded: 1
    tag: direct_group_internal_systems
    tag: direct_queues
</monrun>
<monrun>
 juggler_host:   checks_auto.direct.yandex.ru
    name: CampCopyReportsQueue.copied_reports
    warn: 2
    crit: 5
    expression: 'keepLastValue(direct_one_min.db_configurations.production.flow.CampCopyReportsQueue.copied_reports.shard_$shard)'
    sharded: 1
    tag: direct_group_internal_systems
    tag: direct_queues
</monrun>
<monrun>
 juggler_host:   checks_auto.direct.yandex.ru
    name: CampCopyReportsQueue.error_reports
    warn: 1
    crit: 5
    expression: 'keepLastValue(direct_one_min.db_configurations.production.flow.CampCopyReportsQueue.error_reports.shard_$shard)'
    sharded: 1
    tag: direct_group_internal_systems
    tag: direct_queues
</monrun>
<monrun>
 juggler_host:   checks_auto.direct.yandex.ru
    name: CampCopyReportsQueue.oldest_queue_time
    warn: 3600
    span: 2h
    expression: 'diffSeriesTime(keepLastValue(direct_one_min.db_configurations.production.flow.CampCopyReportsQueue.oldest_queue_time.shard_$shard))'
    sharded: 1
    tag: direct_group_internal_systems
    tag: direct_queues
</monrun>

=cut


=head1 DESCRIPTION

    ppcCampCopyReportsMonitor.pl
    Скрипт предназначен для мониторинга очереди копирования кампаний с отчетом (таблица ppc.camp_copy_reports_queue)
    Непосредственная обработка этой очеди осуществляется скриптом ppcCampCopyReportsQueue.pl

    Обязательные параметры:
        --shard-id N -- номер шарда, с которым работать

=cut


use Direct::Modern;

use ScriptHelper 'Yandex::Log' => 'messages', sharded => 1;
use Settings;

use Yandex::Advmon;
use Yandex::DBTools;

use Yandex::TimeCommon qw/unix2human/;

extract_script_params();


$log->out('START');

my $stat = get_one_line_sql(PPC(shard => $SHARD),
                            "SELECT
                                COUNT(IF(statusReport = 'Done', 1, NULL)) as done_reports,
                                COUNT(IF(statusReport = 'Error', 1, NULL)) as error_reports,
                                COUNT(IF(statusReport = 'New', 1, NULL)) as new_reports,
                                COUNT(IF(statusReport = 'Copied', 1, NULL)) as copied_reports,
                                UNIX_TIMESTAMP(IFNULL(MIN(IF(statusReport in ('New','Copied'), queue_time, NULL)), NOW())) as oldest_queue_time
                             FROM camp_copy_reports_queue");
$log->out("Done reports count: $stat->{done_reports}");
$log->out("New reports count: $stat->{new_reports}");
$log->out("Copied reports count: $stat->{copied_reports}");
$log->out("Oldest queue time: ". unix2human($stat->{oldest_queue_time}));

# пишем данные для мониторинга
local $Yandex::Advmon::GRAPHITE_PREFIX = sub {[qw/direct_one_min db_configurations/, $Settings::CONFIGURATION]};
monitor_values({
    map {( "flow.CampCopyReportsQueue.$_.shard_$SHARD" => $stat->{$_} )} keys %$stat
});

$log->out('Sending OK to juggler');
juggler_ok();

$log->out('FINISH');
