#!/usr/bin/perl

=head1 METADATA

<crontab>
    time: 38 * * * *
    <switchman>
        group: scripts-other
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    ttl: 3h30m
    tag: direct_group_internal_systems
</juggler>

=cut


# $Id$

=head1 DESCRIPTION

Скрипт проверяет появление новых ответов на опросы в surveymonkey.

Ответы пытаются сматчиться с директовыми юзерами по трекинговой переменной,
и при совпадении юзеру ставится отметка о пройденном опросе (таблица users_surveys)

=cut


use strict;
use warnings;
use utf8;
use open ':std' => ':utf8';

use my_inc "..";

use Settings;
use ScriptHelper;
use Property;
use Yandex::DBTools;
use Surveys;
use Net::Surveymonkey;
use POSIX 'strftime';

extract_script_params();

$log->out('START');

my $property = Property->new('last_survey_check');
my $prev_time = $property->get();
my $curr_time = time();

my $complete_success = 1;

# проверяем незаконченные и недавно законченные опросы
my $surveys = Surveys::get_surveys( condition => {
        type => 'surveymonkey',
        _TEXT => 'finish_date > now() - interval 2 day',
    });

SURVEY:
for my $survey (@$surveys) {
    $log->out("checking survey $survey->{survey_id}: $survey->{title}");

    my $ext_survey = Surveys::get_ext_survey($survey);

    my $all_users = get_all_sql(PPC(shard=>'all'), [
            'SELECT uid, ext_user_id, ext_respondent_id, status FROM users_surveys',
            WHERE => { survey_id => $survey->{survey_id} },
        ]);

    my %user_to_check =
        map {(($_->{ext_user_id} || $ext_survey->get_user_id($_->{uid})) => $_->{uid})}
        grep {$_->{status} eq 'New'}
        @$all_users;
    
    if (!%user_to_check) {
        $log->out('nobody to check');
        next SURVEY;
    }

    $log->out(sprintf '%d users to check', scalar keys %user_to_check);

    my %is_known_user =
        map {($_->{ext_respondent_id} => $_->{uid})}
        grep {$_->{status} ne 'New'}
        @$all_users;

    my $sm = Net::Surveymonkey->new();
    my $resp_list_reply = eval { $sm->get_respondent_list({
            survey_id => $survey->{ext_survey_id},
            collector_id => $survey->{ext_collector_id},
            ( $prev_time ? (start_modified_date => strftime("%Y-%m-%d %H:%M:%S", gmtime($prev_time-2000))) : () ),
        }) }
    or do {
        $complete_success = 0;
        $log->out("skipping survey #$survey->{ext_survey_id}: $@");
        next;
    };

    my @new_response_ids =
        grep {!$is_known_user{$_}}
        map {$_->{respondent_id}}
        @{$resp_list_reply->{respondents}};

    if (!@new_response_ids) {
        $log->out('no new responses since last check');
        next SURVEY;
    }

    # TODO: paging?
    my $responses_reply = $sm->get_responses({
            survey_id => $survey->{ext_survey_id},
            respondent_ids => \@new_response_ids,
        });
    
    my $survey_details_reply = $sm->get_survey_details({
            survey_id => $survey->{ext_survey_id},
        });
    my $question_id = $survey_details_reply->{custom_variables}->[0]->{question_id};

    for my $response ( @$responses_reply ) {
        my ($form_id) =
            map {$_->{answers}->[0]->{text}}
            grep {$_->{question_id} eq $question_id}
            @{$response->{questions}};

        next if !$form_id;

        my $uid = $user_to_check{$form_id};
        next if !$uid;

        $log->out("new answer detected: uid=$uid");
        Surveys::complete_user_survey($survey->{survey_id}, uid => $uid, ext_respondent_id => $response->{respondent_id});
    }
}

if ($complete_success) {
    $property->set($curr_time);
    juggler_ok();
}

$log->out('FINISH');

