#!/usr/bin/perl

# $Id$

=head1 METADATA

<crontab>
   time: */59 4 * * *
   sharded: 1
   <switchman>
       group: scripts-other
       <leases>
           mem: 250
       </leases>
   </switchman>
   package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    sharded: 1
    ttl: 2d4h
    tag: direct_group_internal_systems
</juggler>
<crontab>
   time: */15 * * * *
   flock: 1
   sharded: 1
   <switchman>
       group: scripts-test
   </switchman>
   package: conf-test-scripts
</crontab>

=cut

=head1 NAME

    ppcClearEmptyCampaigns.pl

=head1 DESCRIPTION

    Ежедневная очистка базы - удаление давно созданных кампаний с statusEmpty = 'Yes'

=cut

use Direct::Modern;

use Time::HiRes qw//;

use Yandex::DBTools;

use my_inc "..";

use Campaign;
use EnvTools qw/is_beta/;
use RBAC2::Extended;
use ScriptHelper sharded => 1, 'Yandex::Log' => 'messages';
use Settings;

use open ':std' => ':utf8';

# Если даты создания нет - на сколько id отступаем от максимального cid
my $MAX_CID_GAP = 100_000;

# При каких параметрах игнорируем ошибки удаления из rbac
my $MAX_CID_GAP_FORCE = $MAX_CID_GAP * 10;

# Сколько спим после каждого удаления (коэффициент к времени испольнения)
my $SLEEP_COEF = 2;

my $rbac = RBAC2::Extended->get_singleton(1);

my (@client_ids);
extract_script_params(
    'client-id=s' => \@client_ids,
);

if (@client_ids && !is_beta()) {
    die "client-id can only be used on betas";
}

my $clients_only_sql = '1';
if (@client_ids) {
    $Settings::HOURS_EXPIRE = 0;
    $clients_only_sql = sql_condition(['c.ClientID' => \@client_ids]);
}

$log->out("start");

my $max_cid = get_one_field_sql(PPC(shard => $SHARD), "SELECT max(cid) FROM campaigns");

for my $camp ( @{get_all_sql(PPC(shard => $SHARD), "
                        SELECT c.cid, c.uid
                             , (co.create_time < now() - INTERVAL ? DAY
                                OR co.create_time is null AND c.cid < ? * 10
                               ) as force_delete
                          FROM campaigns c
                               LEFT JOIN camp_options co ON co.cid = c.cid
                         WHERE statusEmpty = 'Yes'
                           AND sum = 0
                           AND OrderID = 0
                           AND (co.create_time < now() - INTERVAL ? HOUR
                                OR co.create_time is null AND c.cid < ?
                               )
                           AND $clients_only_sql
                      ", $Settings::DAYS_EXPIRE_FORCE, $MAX_CID_GAP_FORCE,
                         $Settings::HOURS_EXPIRE, $max_cid - $MAX_CID_GAP)} 
) {
    $log->out("Start process cid: $camp->{cid}, uid: $camp->{uid}, force_delete: $camp->{force_delete}");
    my $t = Time::HiRes::time();
    my $ret = eval { 
        del_camp($rbac, $camp->{cid}, $camp->{uid},
                 force => 1,
                 ignore_rbac_errors => $camp->{force_delete},
            ); 
    };
    if ($@ || !$ret) {
        $log->out("Can't delete campaign $camp->{cid}: $@");
    }
    Time::HiRes::sleep( (Time::HiRes::time() - $t) * $SLEEP_COEF );
}

juggler_ok();

$log->out("Finish");
