#!/usr/bin/perl

=head1 METADATA

<crontab>
    time: 11 * * * *
    <switchman>
        group:  scripts-other
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    ttl: 3h
    tag: direct_group_internal_systems
</juggler>

=cut

=head1 DESCRIPTION

    Очистка в метабазе таблиц, отвечающих за генерацию id

=cut

use Direct::Modern;

use Yandex::DBShards;

use my_inc "..";

use Settings;
use Property;
use ScriptHelper 'Yandex::Log' => 'messages';

if (Property->new("ppcClearMetabase__disabled")->get()) {
    $log->out("Temporary disabled due to performance issue DIRECT-139939");
    exit;
}

$log->out("start");

for my $crutch_table (qw/lal_segments client_additional_targetings_id camp_additional_targetings_id/) {
    $log->out("doing cleanup for table $crutch_table");
    local %Yandex::DBShards::SHARD_KEYS = ( id => {table => "inc_$crutch_table", autoinc =>1} );
    Yandex::DBShards::clear_all_autoinc_tables(sleep_coef => 4);
}
$log->out("doing clenaup for tables from Settings");
Yandex::DBShards::clear_all_autoinc_tables(sleep_coef => 4);
juggler_ok();

$log->out("finish");
