#!/usr/bin/perl

use my_inc "..";


# $Id$

=head1 METADATA

<crontab>
    time: 31 3 * * *
    <switchman>
        group: scripts-other
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    ttl: 2d2h
    tag: direct_group_internal_systems
</juggler>

=cut

=head1 NAME

    ppcClearOldManagers.pl

=head1 DESCRIPTION

    Будем проверять - если логин менеджера/тимлидера/супертимлидера заблокирован
    в интерфейсе (т.е. была попытка удаления логина управлятором,
    но не получилось из-за наличия не перенесенных клиентов/менеджеров)
    и при этом под ним нет подчиненных сущностей, мы удалим роль и в Директе.

    https://jira.yandex-team.ru/browse/DIRECT-19713

=cut

use strict;
use warnings;

use Yandex::DBTools;
use Yandex::DBShards;

use ScriptHelper;

use Settings;
use RBACDirect;
use RBAC2::Extended;

use utf8;
use open ':std' => ':utf8';

# --------------------------------------------------------------------
sub main {
    $log->out("start");

    my $rbac = RBAC2::Extended->get_singleton(1);

    my $all_managers_uids = rbac_get_all_managers($rbac);
    return unless @$all_managers_uids;

    my $blocked_managers = get_all_sql(PPC(uid => $all_managers_uids), [
        "select uid, login
         from users
        ", where => {uid => SHARD_IDS, statusBlocked => 'Yes'}
    ]);
    $log->out({all_blocked_managers => $blocked_managers});

    for my $row (@$blocked_managers) {
        my $uid = $row->{uid};
        my $role;

        # если это тимлидер, то самого менеджера удалим на следующей итерации на следующий день
        if (rbac_is_superteamleader($rbac, $uid)) {
            next if rbac_get_team_of_superteamleader($rbac, $uid); # еще есть своя группа, пропускаем
            $role = 'superteamleader';
        } elsif (rbac_is_teamleader($rbac, $uid)) {
            next if rbac_get_managers_of_teamleader($rbac, $uid); # еще есть своя группа, пропускаем
            $role = 'teamleader';
        } else {
            # иначе это простой менеджер
            next if @{rbac_get_agencies_uids($rbac, $uid)} # есть агентства
                    || @{rbac_get_clients_of_manager($rbac, $uid)}; # есть клиенты, пропускаем
            $role = 'manager';
        }

        my $result = rbac_drop_user($rbac, $uid, $role);
        $log->out({delete_manager => 1, uid => $uid, role => $role, login => $row->{login}, result => $result});
    }

    juggler_ok();

    $log->out("finish");
}

# --------------------------------------------------------------------
main();
