#!/usr/bin/perl

use my_inc "..";

=head1 NAME

    ppcClearOldPhrasesCache.pl

=head1 DESCRIPTION

    Очистить кеш добавленных из отчетов по ДРФ фраз от слишком старых записей
    (старше $Stat::AddedPhrasesCache::CACHE_STORAGE_DAYS дней)

=head1 USAGE

    LOG_TEE=1 ./protected/ppcClearOldPhrasesCache.pl --shard-id=6

=cut

=head1 METADATA

<crontab>
    time: */59 * * * *
    sharded: 1
    package: scripts-switchman
    <switchman>
        group: scripts-other
        <leases>
            mem: 200
        </leases>
    </switchman>
</crontab>

<juggler>
    host:   checks_auto.direct.yandex.ru
    sharded:        1
    ttl:            4h
    tag: direct_group_internal_systems
</juggler>

=cut

use strict;
use warnings;

use ScriptHelper sharded => 1, 'Yandex::Log' => 'messages';

use Stat::AddedPhrasesCache;

use utf8;

extract_script_params();

$log->out('START');

my $cnt = Stat::AddedPhrasesCache::delete_old_phrases_from_cache(shard => $SHARD);
$log->out("Succesfully deleted $cnt entries");

$log->out('Writing to juggler queue');
juggler_ok();

$log->out('FINISH');

