#!/usr/bin/perl

use my_inc "..";

=head1 NAME

    ppcClearOldReports.pl

=head1 DESCRIPTION

    Удаляет старые отчёты:
        * PDF [PPC.pdf_reports]
        * BroadMatch [PPC.bm_reports]
        * stat_mp/client_potential/... [PPC.stat_reports]
        * XLS [PPCDICT.xls_reports]

=head1 USAGE

    LOG_TEE=1 ./protected/ppcClearOldReports.pl --shard-id=6

=cut

=head1 METADATA

<crontab>
    time: 12 3,4,5,6,7 * * *
    sharded: 1
    package: scripts-switchman
    <switchman>
        group: scripts-other
        <leases>
            mem: 40
        </leases>
    </switchman>
</crontab>

<juggler>
    host:   checks_auto.direct.yandex.ru
    sharded:        1
    ttl:            2d4h
    tag: direct_group_internal_systems
</juggler>

=cut

use strict;
use warnings;

use ScriptHelper sharded => 1, 'Yandex::Log' => 'messages';

use Settings;
use PdfReport::Queue;
use PdfReport;
use CampStat;
use Reports::Queue;
use Property;

use Yandex::TimeCommon;

use utf8;

extract_script_params();

$log->out('START');

my $last_success_date_prop = new Property("ppcClearOldReports_last_success_date_shard_$SHARD");
my $last_success_date = $last_success_date_prop->get();
my $today = today();
if ($last_success_date && $last_success_date eq $today) {
    $log->out("Script has already succeded today, exitting");
    exit(0);
}

$log->out('Clearing PdfReports');
PdfReport::Queue::clearOldPdfReports( shard => $SHARD );

$log->out('Clearing BMReports');
PdfReport::clearOldBMReports( shard => $SHARD );

for my $type (keys %Reports::Queue::REPORT_TYPES) {
    $log->out("Clearing report queue type $type");
    my $queue = new Reports::Queue( type => $type );
    $queue->clear_old_reports(shard => $SHARD);
}

$log->out('Clearing XLS stat reports');
if ($SHARD == 1) {
    # не чистим таблицу с очередью SHARD_NUM раз, хватит одного
    CampStat::clear_old_orders();
}
$log->out("removing xls_reports from Storage");
my $storage = Direct::Storage->new();
my @removed = $storage->remove_old_files($SHARD, 'xls_reports', 2 * 7 * 24 * 60 * 60); # 2 weeks
$log->out({removed_xls_reports => \@removed});

$log->out('Writing property');
$last_success_date_prop->set($today);

$log->out('Writing to juggler queue');
juggler_ok();

$log->out('FINISH');

