#!/usr/bin/perl

use my_inc "..";


=head1 METADATA

<crontab>
    time: */5 * * * *
    sharded: 1
    <switchman>
        group: scripts-other
    </switchman>
    package: scripts-switchman
</crontab>

<juggler>
    host:   checks_auto.direct.yandex.ru
    sharded: 1
    ttl:     1800
    tag: direct_group_internal_systems
</juggler>

=cut


=head1 DESCRIPTION

    ppcCurrencyConvertMonitor.pl
    Скрипт предназначен для мониторинга очереди конвертации в валюту (таблица ppc.currency_convert_queue)
    Непосредственная обработка этой очеди осуществляется скриптом ppcCurrencyConvertWorker.pl

    Обязательные параметры:
        --shard-id N -- номер шарда, с которым работать

=cut


use Direct::Modern;

use ScriptHelper sharded => 1;
use Settings;

use Yandex::Advmon;
use Yandex::DBTools;

extract_script_params();


$log->out('START');

my $stat = get_one_line_sql(PPC(shard => $SHARD),
                            "SELECT
                                COUNT(IF(state = 'NEW', 1, NULL)) as new,
                                COUNT(IF(state = 'STOPPED', 1, NULL)) as stopped,
                                COUNT(IF(state = 'DONE', 1, NULL)) as done,
                                COUNT(IF(state = 'BALANCE_NOTIFIED', 1, NULL)) as balance_notified
                             FROM currency_convert_queue");
$log->out("New reports count: $stat->{new}");
$log->out("Stopped reports count: $stat->{stopped}");
$log->out("Done reports count: $stat->{done}");
$log->out("Balance_notified reports count: $stat->{balance_notified}");

# пишем данные для мониторинга
local $Yandex::Advmon::GRAPHITE_PREFIX = sub {[qw/direct_one_min db_configurations/, $Settings::CONFIGURATION]};
monitor_values({
    map {( "flow.CurrencyConvertQueue.$_.shard_$SHARD" => $stat->{$_} )} keys %$stat
});

$log->out('Sending OK to juggler');
juggler_ok();

$log->out('FINISH');
