#!/usr/bin/perl

=head1 METADATA

<crontab>
    time: */59 2-4 * * *
    sharded: 1
    <switchman>
        group: scripts-other
        <leases>
            mem: 200
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    sharded: 1
    ttl:     2d4h
    tag: direct_group_internal_systems
</juggler>

=cut

=head1 NAME

$Id$

=head1 DESCRIPTION

    Удаление визиток, которые не привязанны к баннерам(и медиапланам), и которые не использовались более 30 дней.

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;

use my_inc "..";

use ScriptHelper sharded => 1, 'Yandex::Log' => 'messages';
use Settings;
use VCards;

# количество визиток, обрабатываемых за раз
my $VCARDS_PER_STEP = 50000;
# количество дней, по истечении которых удалять не использующуюся визитку
my $LIVE_DAYS = 30;

extract_script_params();

$log->out('start');
while (my $vcards = get_next_unlink_vcards()) {
    $log->out("selected " . scalar(@$vcards) . " vcards");
    my $deleted = delete_vcard_from_db($vcards);
    $log->out("deleted " . scalar(@$deleted) . " vcards");
    $log->out("deleted vcard ids: " . join ',', @$deleted);
}
juggler_ok();
$log->out('finish');

{
my ($min_vcard_id, $max_vcard_id);
sub get_next_unlink_vcards {
    
    unless (defined $max_vcard_id) {
        $min_vcard_id = 0;
        $max_vcard_id = get_one_field_sql(PPC(shard => $SHARD), "SELECT MAX(vcard_id) FROM vcards");
    }
    
    my @unlink_vcards;
    while ($min_vcard_id < $max_vcard_id && !@unlink_vcards) {
        my @old_vcards;
        while ($min_vcard_id < $max_vcard_id && !@old_vcards) {
            @old_vcards = @{get_one_column_sql(PPC(shard => $SHARD), "SELECT vcard_id FROM vcards vc WHERE vc.last_dissociation < current_date - interval ? day AND vcard_id BETWEEN ? AND ?",
                                    $LIVE_DAYS, $min_vcard_id, $min_vcard_id + $VCARDS_PER_STEP)||[]};
            my $vcards_shards = get_shard_multi(vcard_id => \@old_vcards);
            @old_vcards = grep {defined $vcards_shards->{$_} && $vcards_shards->{$_} == $SHARD} @old_vcards;
            $min_vcard_id += $VCARDS_PER_STEP + 1;
        }
        
        next unless @old_vcards;
        
        @unlink_vcards = @{get_one_column_sql(PPC(shard => $SHARD),
                            "SELECT vc.vcard_id
                            FROM vcards vc
                            LEFT JOIN banners b ON vc.vcard_id = b.vcard_id
                            LEFT JOIN mediaplan_banners mb ON vc.vcard_id = mb.vcard_id
                            WHERE b.bid IS NULL AND mb.mbid IS NULL AND vc.vcard_id IN (" . join(',', @old_vcards) . ")") || []};
    }

    return @unlink_vcards ? \@unlink_vcards : undef;
}
}
