#!/usr/bin/perl
use Direct::Modern;

=head1 NAME

protected/ppcFillDBQueueJobTypes.pl

=head1 SYNOPSIS

    protected/ppcFillDBQueueJobTypes.pl

=head1 DESCRIPTION

Скрипт, который вызывает Yandex::DBQueue::Typemap::fill_job_types на всех шардах и в ppcdict.
См. документацию на Yandex::DBQueue::Typemap::fill_job_types.

=head1 METADATA

<crontab>
    time: */59 * * * *
    package: scripts-switchman
    <switchman>
        group: scripts-other
    </switchman>
</crontab>
<crontab>
    env: SETTINGS_LOCAL_SUFFIX=Dev7
    time: */59 * * * *
    package: dev-scripts
</crontab>
<crontab>
    env: SETTINGS_LOCAL_SUFFIX=DevTest
    time: */59 * * * *
    package: dev-scripts
</crontab>
<crontab>
    time: */59 * * * *
    <switchman>
        group: scripts-test
    </switchman>
    package: conf-test-scripts
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    ttl:        4h
    tag: direct_group_internal_systems
</juggler>

=cut

use my_inc '..';

use Yandex::DBQueue::Typemap;

use Settings;
use ScriptHelper;
use ShardingTools;

extract_script_params();

$log->out('start');

my $ok = 1;

for my $shard (ppc_shards()) {
    fill_db( "ppc:$shard", PPC( shard => $shard ) );
}

fill_db( "ppcdict", PPCDICT() );

if ($ok) {
    juggler_ok();
}

$log->out('finish');

sub fill_db {
    my ($dbname, $db) = @_;
    my $log_guard = $log->msg_prefix_guard("[$dbname]");
    eval {
        my $typemap = Yandex::DBQueue::Typemap->new($db);
        my $inserted_rows =  $typemap->fill_job_types( log => $log );
        $log->out("total inserted rows: $inserted_rows");
    };

    if ($@) {
        $log->warn($@);
        $ok = 0;
    }
}
