#!/usr/bin/perl
=pod
    $Id$
    Скрипт, замеряющий размер очереди ppcGetAdvqShowsNew.pl на пересчет прогноза показов,
    записывает результат в логи и зажигает лампочку в Juggler.

    Замер вынесен из скрипта обработки, чтобы запускаться реже (это тяжелая операция на накопившейся очереди)

=cut

=head1 METADATA

<crontab>
    time: */59 6 * * *
    package: scripts-switchman
    <switchman>
        group: scripts-other
        <leases>
            mem: 50
        </leases>
    </switchman>
</crontab>

# сам скрипт
<juggler>
    host:   checks_auto.direct.yandex.ru
    ttl:            26h
    tag: direct_group_internal_systems
</juggler>
# необработанная очередь
<juggler_check>
    host:   checks_auto.direct.yandex.ru
    name:           scripts.ppcGetAdvqShowsNew.unprocessed_groups_count
    raw_events:     scripts.ppcGetAdvqShowsNew.unprocessed_groups_count.shard_$shard.production
    sharded:        1
    ttl:            26h
    tag: direct_group_internal_systems
    tag: direct_queues
</juggler_check>

=cut

use strict;
use warnings;
use utf8;

use my_inc '..';

use List::MoreUtils qw/all/;

use Yandex::DBShards;
use Yandex::DBTools;

use Settings;
use ScriptHelper 'Yandex::Log' => 'messages';
use ShardingTools;

# пороги для мониторинга - количество необработанных групп в шарде
# старые значения: 55/70 миллионов
my $WARN_BORDER = 5_000_000;
my $CRIT_BORDER = 25_000_000;

$log->out('START');

my $result = foreach_shard_parallel(shard => [ppc_shards()], sub {
    my $shard = shift;
    my $log_prefix_guard = $log->msg_prefix_guard("shard $shard:");

    $log->out('counting processing groups in db');
    my $pids_count = get_one_field_sql(PPC(shard => $shard), q!
          SELECT COUNT(*)
            FROM phrases p
                 JOIN campaigns c USING(cid)
           WHERE p.statusShowsForecast = 'Sending'
             AND c.archived = 'No'
             AND c.statusEmpty = 'No'
    !) // 0;

    $log->out("groups for processing - $pids_count");

    juggler_check(service => "scripts.ppcGetAdvqShowsNew.unprocessed_groups_count.shard_$shard",
                  description => "Unprocessed groups count",
                  value => $pids_count,
                  crit => $CRIT_BORDER,
                  warn => $WARN_BORDER
    );
});

my @error_in_shards = grep { ! all { $_ } @{$result->{$_}} } keys %$result;
if (@error_in_shards) {
    $log->out({result => $result});
    $log->die("Error in shards: " . join(', ', @error_in_shards));
}

juggler_ok();

$log->out('FINISH');
